<?php

namespace app\admin\validate;

use think\Validate;

class Member extends Validate
{
    /**
     * 验证规则
     */
    protected $rule = [
        'username' => 'require|unique:member',
    ];
    /**
     * 提示消息
     */
    protected $message = [
    ];
    /**
     * 验证场景
     */
    protected $scene = [
        'add'  => ['username'],
        'edit' => ['username'],
    ];

    public function __construct(array $rules = [], $message = [], $field = [])
    {
        $this->field = [
            'username' => __('Login Name')
        ];
        $ids = input('ids');
        if (!empty($ids)){
            $this->rule['username'] = 'require|unique:member,username,'.input('ids');
        }
        parent::__construct($rules, $message, $field);
    }
    
}
