<?php

namespace app\admin\validate;

use think\Validate;

class Package extends Validate
{
    /**
     * 验证规则
     */
    protected $rule = [
        'packagename' => 'require|unique:package',
    ];
    /**
     * 提示消息
     */
    protected $message = [
        'add'  => [],
        'edit' => [],
    ];
    /**
     * 验证场景
     */
    protected $scene = [
        'add'  => ['packagename'],
        'edit' => ['packagename'],
    ];

    public function __construct(array $rules = [], $message = [], $field = [])
    {
        $this->field = [
            'packagename' => __('Membership Type Name')
        ];
        $ids = input('ids');
        if (!empty($ids)){
            $this->rule['packagename'] = 'require|unique:package,packagename,'.input('ids');
        }
        parent::__construct($rules, $message, $field);
    }
    
}
