<?php

namespace app\admin\validate;

use think\Validate;

class Resort extends Validate
{
    /**
     * 验证规则
     */
    protected $rule = [
        'resortcode' => 'require|unique:resort',
        'resortname' => 'require|unique:resort',
    ];
    /**
     * 提示消息
     */
    protected $message = [
    ];
    /**
     * 验证场景
     */
    protected $scene = [
        'add'  => ['resortcode','resortname'],
        'edit' => ['resortcode','resortname'],
    ];
    public function __construct(array $rules = [], $message = [], $field = [])
    {
        $this->field = [
            'resortcode' => __('Resort Code'),
            'resortname' => __('Resort Name'),
        ];
        $ids = input('ids');
        if (!empty($ids)){
            $this->rule['resortcode'] = 'require|unique:resort,resortcode,'.input('ids');
            $this->rule['resortname'] = 'require|unique:resort,resortname,'.input('ids');
        }
        parent::__construct($rules, $message, $field);
    }
}
