<?php

namespace app\admin\validate\addition;

use think\Validate;

class Group extends Validate
{
    /**
     * 验证规则
     */
    protected $rule = [
        'addition_group_name' => 'require|unique:addition_group',
    ];
    /**
     * 提示消息
     */
    protected $message = [
    ];
    /**
     * 验证场景
     */
    protected $scene = [
        'add'  => ['addition_group_name'],
        'edit' => ['addition_group_name'],
    ];
    public function __construct(array $rules = [], $message = [], $field = [])
    {
        $this->field = [
            'addition_group_name' => __('Addition Price Name')
        ];
        $ids = input('ids');
        if (!empty($ids)){
            $this->rule['addition_group_name'] = 'require|unique:addition_group,addition_group_name,'.input('ids');
        }
        parent::__construct($rules, $message, $field);
    }
}
