<?php

namespace app\admin\validate\addition;

use think\Validate;

class Rate extends Validate
{
    /**
     * 验证规则
     */
    protected $rule = [
        'addition_rate_name' => 'require|unique:addition_rate',
    ];
    /**
     * 提示消息
     */
    protected $message = [
    ];
    /**
     * 验证场景
     */
    protected $scene = [
        'add'  => ['addition_rate_name'],
        'edit' => ['addition_rate_name'],
    ];

    public function __construct(array $rules = [], $message = [], $field = [])
    {
        $this->field = [
            'addition_rate_name' => __('Addition Rate Name')
        ];
        $ids = input('ids');
        if (!empty($ids)){
            $this->rule['addition_rate_name'] = 'require|unique:addition_rate,addition_rate_name,'.input('ids');
        }
        parent::__construct($rules, $message, $field);
    }
}
