<?php

// 公共助手函数

use app\admin\library\Auth;
use app\admin\model\Booking;
use app\admin\model\invoice\bank\Transaction;
use app\admin\model\membership\Detail;
use app\admin\model\Orders;
use app\admin\model\orders\Addi;
use app\admin\model\orders\Bonus;
use app\admin\model\orders\Extra;
use app\admin\model\orders\Van;
use app\admin\model\payment\Record;
use app\admin\model\response\Test;
use app\admin\model\Send2bank;
use think\Db;
use think\db\exception\DataNotFoundException;
use think\db\exception\ModelNotFoundException;
use think\exception\DbException;
use think\exception\HttpResponseException;
use think\Response;

if (!function_exists('__')) {

    /**
     * 获取语言变量值
     * @param string $name 语言变量名
     * @param string | array $vars 动态变量值
     * @param string $lang 语言
     * @return mixed
     */
    function __($name, $vars = [], $lang = '')
    {
        if (is_numeric($name) || !$name) {
            return $name;
        }
        if (!is_array($vars)) {
            $vars = func_get_args();
            array_shift($vars);
            $lang = '';
        }
        return \think\Lang::get($name, $vars, $lang);
    }
}

if (!function_exists('format_bytes')) {

    /**
     * 将字节转换为可读文本
     * @param int $size 大小
     * @param string $delimiter 分隔符
     * @param int $precision 小数位数
     * @return string
     */
    function format_bytes($size, $delimiter = '', $precision = 2)
    {
        $units = array('B', 'KB', 'MB', 'GB', 'TB', 'PB');
        for ($i = 0; $size >= 1024 && $i < 5; $i++) {
            $size /= 1024;
        }
        return round($size, $precision) . $delimiter . $units[$i];
    }
}

if (!function_exists('datetime')) {

    /**
     * 将时间戳转换为日期时间
     * @param int $time 时间戳
     * @param string $format 日期时间格式
     * @return string
     */
    function datetime($time, $format = 'Y-m-d H:i:s')
    {
        $time = is_numeric($time) ? $time : strtotime($time);
        return date($format, $time);
    }
}

if (!function_exists('human_date')) {

    /**
     * 获取语义化时间
     * @param int $time 时间
     * @param int $local 本地时间
     * @return string
     */
    function human_date($time, $local = null)
    {
        return \fast\Date::human($time, $local);
    }
}

if (!function_exists('cdnurl')) {

    /**
     * 获取上传资源的CDN的地址
     * @param string $url 资源相对地址
     * @param boolean $domain 是否显示域名 或者直接传入域名
     * @return string
     */
    function cdnurl($url, $domain = false)
    {
        $regex = "/^((?:[a-z]+:)?\/\/|data:image\/)(.*)/i";
        $cdnurl = \think\Config::get('upload.cdnurl');
        if (is_bool($domain) || stripos($cdnurl, '/') === 0) {
            $url = preg_match($regex, $url) || ($cdnurl && stripos($url, $cdnurl) === 0) ? $url : $cdnurl . $url;
        }
        if ($domain && !preg_match($regex, $url)) {
            $domain = is_bool($domain) ? request()->domain() : $domain;
            $url = $domain . $url;
        }
        return $url;
    }
}


if (!function_exists('is_really_writable')) {

    /**
     * 判断文件或文件夹是否可写
     * @param string $file 文件或目录
     * @return    bool
     */
    function is_really_writable($file)
    {
        if (DIRECTORY_SEPARATOR === '/') {
            return is_writable($file);
        }
        if (is_dir($file)) {
            $file = rtrim($file, '/') . '/' . md5(mt_rand());
            if (($fp = @fopen($file, 'ab')) === false) {
                return false;
            }
            fclose($fp);
            @chmod($file, 0777);
            @unlink($file);
            return true;
        } elseif (!is_file($file) or ($fp = @fopen($file, 'ab')) === false) {
            return false;
        }
        fclose($fp);
        return true;
    }
}

if (!function_exists('rmdirs')) {

    /**
     * 删除文件夹
     * @param string $dirname 目录
     * @param bool $withself 是否删除自身
     * @return boolean
     */
    function rmdirs($dirname, $withself = true)
    {
        if (!is_dir($dirname)) {
            return false;
        }
        $files = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($dirname, RecursiveDirectoryIterator::SKIP_DOTS),
            RecursiveIteratorIterator::CHILD_FIRST
        );

        foreach ($files as $fileinfo) {
            $todo = ($fileinfo->isDir() ? 'rmdir' : 'unlink');
            $todo($fileinfo->getRealPath());
        }
        if ($withself) {
            @rmdir($dirname);
        }
        return true;
    }
}

if (!function_exists('copydirs')) {

    /**
     * 复制文件夹
     * @param string $source 源文件夹
     * @param string $dest 目标文件夹
     */
    function copydirs($source, $dest)
    {
        if (!is_dir($dest)) {
            mkdir($dest, 0755, true);
        }
        foreach (
            $iterator = new RecursiveIteratorIterator(
                new RecursiveDirectoryIterator($source, RecursiveDirectoryIterator::SKIP_DOTS),
                RecursiveIteratorIterator::SELF_FIRST
            ) as $item
        ) {
            if ($item->isDir()) {
                $sontDir = $dest . DS . $iterator->getSubPathName();
                if (!is_dir($sontDir)) {
                    mkdir($sontDir, 0755, true);
                }
            } else {
                copy($item, $dest . DS . $iterator->getSubPathName());
            }
        }
    }
}

if (!function_exists('mb_ucfirst')) {
    function mb_ucfirst($string)
    {
        return mb_strtoupper(mb_substr($string, 0, 1)) . mb_strtolower(mb_substr($string, 1));
    }
}

if (!function_exists('addtion')) {

    /**
     * 附加关联字段数据
     * @param array $items 数据列表
     * @param mixed $fields 渲染的来源字段
     * @return array
     */
    function addtion($items, $fields)
    {
        if (!$items || !$fields) {
            return $items;
        }
        $fieldsArr = [];
        if (!is_array($fields)) {
            $arr = explode(',', $fields);
            foreach ($arr as $k => $v) {
                $fieldsArr[$v] = ['field' => $v];
            }
        } else {
            foreach ($fields as $k => $v) {
                if (is_array($v)) {
                    $v['field'] = $v['field'] ?? $k;
                } else {
                    $v = ['field' => $v];
                }
                $fieldsArr[$v['field']] = $v;
            }
        }
        foreach ($fieldsArr as $k => &$v) {
            $v = is_array($v) ? $v : ['field' => $v];
            $v['display'] = $v['display'] ?? str_replace(['_ids', '_id'], ['_names', '_name'], $v['field']);
            $v['primary'] = $v['primary'] ?? '';
            $v['column'] = $v['column'] ?? 'name';
            $v['model'] = $v['model'] ?? '';
            $v['table'] = $v['table'] ?? '';
            $v['name'] = $v['name'] ?? str_replace(['_ids', '_id'], '', $v['field']);
        }
        unset($v);
        $ids = [];
        $fields = array_keys($fieldsArr);
        foreach ($items as $k => $v) {
            foreach ($fields as $m => $n) {
                if (isset($v[$n])) {
                    $ids[$n] = array_merge(isset($ids[$n]) && is_array($ids[$n]) ? $ids[$n] : [], explode(',', $v[$n]));
                }
            }
        }
        $result = [];
        foreach ($fieldsArr as $k => $v) {
            if ($v['model']) {
                $model = new $v['model'];
            } else {
                // 优先判断使用table的配置
                $model = $v['table'] ? Db::table($v['table']) : Db::name($v['name']);
            }
            $primary = $v['primary'] ?: $model->getPk();
            $result[$v['field']] = isset($ids[$v['field']]) ? $model->where($primary, 'in', $ids[$v['field']])->column($v['column'], $primary) : [];
        }

        foreach ($items as $k => &$v) {
            foreach ($fields as $m => $n) {
                if (isset($v[$n])) {
                    $curr = array_flip(explode(',', $v[$n]));

                    $linedata = array_intersect_key($result[$n], $curr);
                    $v[$fieldsArr[$n]['display']] = $fieldsArr[$n]['column'] == '*' ? $linedata : implode(',', $linedata);
                }
            }
        }
        return $items;
    }
}

if (!function_exists('var_export_short')) {

    /**
     * 使用短标签打印或返回数组结构
     * @param mixed $data
     * @param boolean $return 是否返回数据
     * @return string
     */
    function var_export_short($data, $return = true)
    {
        return var_export($data, $return);
    }
}

if (!function_exists('letter_avatar')) {
    /**
     * 首字母头像
     * @param $text
     * @return string
     */
    function letter_avatar($text)
    {
        $total = unpack('L', hash('adler32', $text, true))[1];
        $hue = $total % 360;
        list($r, $g, $b) = hsv2rgb($hue / 360, 0.3, 0.9);

        $bg = "rgb({$r},{$g},{$b})";
        $color = "#ffffff";
        $first = mb_strtoupper(mb_substr($text, 0, 1));
        $src = base64_encode('<svg xmlns="http://www.w3.org/2000/svg" version="1.1" height="100" width="100"><rect fill="' . $bg . '" x="0" y="0" width="100" height="100"></rect><text x="50" y="50" font-size="50" text-copy="fast" fill="' . $color . '" text-anchor="middle" text-rights="admin" dominant-baseline="central">' . $first . '</text></svg>');
        $value = 'data:image/svg+xml;base64,' . $src;
        return $value;
    }
}

if (!function_exists('hsv2rgb')) {
    function hsv2rgb($h, $s, $v)
    {
        $r = $g = $b = 0;

        $i = floor($h * 6);
        $f = $h * 6 - $i;
        $p = $v * (1 - $s);
        $q = $v * (1 - $f * $s);
        $t = $v * (1 - (1 - $f) * $s);

        switch ($i % 6) {
            case 0:
                $r = $v;
                $g = $t;
                $b = $p;
                break;
            case 1:
                $r = $q;
                $g = $v;
                $b = $p;
                break;
            case 2:
                $r = $p;
                $g = $v;
                $b = $t;
                break;
            case 3:
                $r = $p;
                $g = $q;
                $b = $v;
                break;
            case 4:
                $r = $t;
                $g = $p;
                $b = $v;
                break;
            case 5:
                $r = $v;
                $g = $p;
                $b = $q;
                break;
        }

        return [
            floor($r * 255),
            floor($g * 255),
            floor($b * 255)
        ];
    }
}

if (!function_exists('check_nav_active')) {
    /**
     * 检测会员中心导航是否高亮
     */
    function check_nav_active($url, $classname = 'active')
    {
        $auth = \app\common\library\Auth::instance();
        $requestUrl = $auth->getRequestUri();
        $url = ltrim($url, '/');
        return $requestUrl === str_replace(".", "/", $url) ? $classname : '';
    }
}

if (!function_exists('check_cors_request')) {
    /**
     * 跨域检测
     */
    function check_cors_request()
    {
        if (isset($_SERVER['HTTP_ORIGIN']) && $_SERVER['HTTP_ORIGIN'] && config('fastadmin.cors_request_domain')) {
            $info = parse_url($_SERVER['HTTP_ORIGIN']);
            $domainArr = explode(',', config('fastadmin.cors_request_domain'));
            $domainArr[] = request()->host(true);
            if (in_array("*", $domainArr) || in_array($_SERVER['HTTP_ORIGIN'], $domainArr) || (isset($info['host']) && in_array($info['host'], $domainArr))) {
                header("Access-Control-Allow-Origin: " . $_SERVER['HTTP_ORIGIN']);
            } else {
                $response = Response::create('跨域检测无效', 'html', 403);
                throw new HttpResponseException($response);
            }

            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');

            if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
                if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
                }
                if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                    header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
                }
                $response = Response::create('', 'html');
                throw new HttpResponseException($response);
            }
        }
    }
}

if (!function_exists('xss_clean')) {
    /**
     * 清理XSS
     */
    function xss_clean($content, $is_image = false)
    {
        return \app\common\library\Security::instance()->xss_clean($content, $is_image);
    }
}

if (!function_exists('url_clean')) {
    /**
     * 清理URL
     */
    function url_clean($url)
    {
        if (!check_url_allowed($url)) {
            return '';
        }
        return xss_clean($url);
    }
}

if (!function_exists('check_ip_allowed')) {
    /**
     * 检测IP是否允许
     * @param string $ip IP地址
     */
    function check_ip_allowed($ip = null)
    {
        $ip = is_null($ip) ? request()->ip() : $ip;
        $forbiddenipArr = config('site.forbiddenip');
        $forbiddenipArr = !$forbiddenipArr ? [] : $forbiddenipArr;
        $forbiddenipArr = is_array($forbiddenipArr) ? $forbiddenipArr : array_filter(explode("\n", str_replace("\r\n", "\n", $forbiddenipArr)));
        if ($forbiddenipArr && \Symfony\Component\HttpFoundation\IpUtils::checkIp($ip, $forbiddenipArr)) {
            $response = Response::create('请求无权访问', 'html', 403);
            throw new HttpResponseException($response);
        }
    }
}

if (!function_exists('check_url_allowed')) {
    /**
     * 检测URL是否允许
     * @param string $url URL
     * @return bool
     */
    function check_url_allowed($url = '')
    {
        //允许的主机列表
        $allowedHostArr = [
            strtolower(request()->host())
        ];

        if (empty($url)) {
            return true;
        }

        //如果是站内相对链接则允许
        if (preg_match("/^[\/a-z][a-z0-9][a-z0-9\.\/]+((\?|#).*)?\$/i", $url) && substr($url, 0, 2) !== '//') {
            return true;
        }

        //如果是站外链接则需要判断HOST是否允许
        if (preg_match("/((http[s]?:\/\/)+((?>[a-z\-0-9]{2,}\.)+[a-z]{2,8}|((?>([0-9]{1,3}\.)){3}[0-9]{1,3}))(:[0-9]{1,5})?)(?:\s|\/)/i", $url)) {
            $chkHost = parse_url(strtolower($url), PHP_URL_HOST);
            if ($chkHost && in_array($chkHost, $allowedHostArr)) {
                return true;
            }
        }

        return false;
    }
}

if (!function_exists('build_suffix_image')) {
    /**
     * 生成文件后缀图片
     * @param string $suffix 后缀
     * @param null $background
     * @return string
     */
    function build_suffix_image($suffix, $background = null)
    {
        $suffix = mb_substr(strtoupper($suffix), 0, 4);
        $total = unpack('L', hash('adler32', $suffix, true))[1];
        $hue = $total % 360;
        list($r, $g, $b) = hsv2rgb($hue / 360, 0.3, 0.9);

        $background = $background ? $background : "rgb({$r},{$g},{$b})";

        $icon = <<<EOT
        <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
            <path style="fill:#E2E5E7;" d="M128,0c-17.6,0-32,14.4-32,32v448c0,17.6,14.4,32,32,32h320c17.6,0,32-14.4,32-32V128L352,0H128z"/>
            <path style="fill:#B0B7BD;" d="M384,128h96L352,0v96C352,113.6,366.4,128,384,128z"/>
            <polygon style="fill:#CAD1D8;" points="480,224 384,128 480,128 "/>
            <path style="fill:{$background};" d="M416,416c0,8.8-7.2,16-16,16H48c-8.8,0-16-7.2-16-16V256c0-8.8,7.2-16,16-16h352c8.8,0,16,7.2,16,16 V416z"/>
            <path style="fill:#CAD1D8;" d="M400,432H96v16h304c8.8,0,16-7.2,16-16v-16C416,424.8,408.8,432,400,432z"/>
            <g><text><tspan x="220" y="380" font-size="124" font-family="Verdana, Helvetica, Arial, sans-serif" fill="white" text-anchor="middle">{$suffix}</tspan></text></g>
        </svg>
EOT;
        return $icon;
    }
}

function binmd5($val)
{
    return pack("H*", md5($val));
}

function bytexor($a, $b, $l)
{
    $c = "";
    for ($i = 0; $i < $l; $i++) {
        if (isset($a[$i]) && isset($b[$i])) {
            $c .= $a[$i] ^ $b[$i];
        }
    }
    return $c;
}

/**
 * 加密
 * @param $msg
 * @param $heslo
 * @return string
 */
function crypt_md5($msg, $heslo = 'HCS')
{
    $msg =  @mb_convert_encoding($msg, 'cp1252', 'UTF-8');
    $key = $heslo;
    $sifra = "";
    $key1 = binmd5($key);
    while ($msg) {
        $m = substr($msg, 0, 16);
        $msg = substr($msg, 16);
        $sifra .= bytexor($m, $key1, 16);
        $key1 = binmd5($key . $key1 . $m);
    }
    return addslashes($sifra);
}

/**
 * 解密
 * @param $msg
 * @param $heslo
 * @return string
 */
function decrypt_md5($msg, $heslo = 'HCS')
{
    $key = $heslo;
    $sifra = "";
    $msg = stripslashes($msg);
    $key1 = binmd5($key);
    while ($msg) {
        $m = substr($msg, 0, 16);
        $msg = substr($msg, 16);
        $sifra .= $m = bytexor($m, $key1, 16);
        $key1 = binmd5($key . $key1 . $m);
    }
    return $sifra;
}

function availableTime($MSTimeparams)
{
    $Total = $MSTimeparams["Week_per_Year"];
    $LeftMidweek = 0;
    $LeftWeekend = 0;

    $MSTimeparams["Booking_Full_Week"] = (trim($MSTimeparams["Booking_Full_Week"]) == "") ? 0 : $MSTimeparams["Booking_Full_Week"];
    $MSTimeparams["Booking_Mid_Week"] = (trim($MSTimeparams["Booking_Mid_Week"]) == "") ? 0 : $MSTimeparams["Booking_Mid_Week"];
    $MSTimeparams["Booking_Weekend"] = (trim($MSTimeparams["Booking_Weekend"]) == "") ? 0 : $MSTimeparams["Booking_Weekend"];
    $MSTimeparams["MSB_Detail_UsedFW"] = (trim($MSTimeparams["MSB_Detail_UsedFW"]) == "") ? 0 : $MSTimeparams["MSB_Detail_UsedFW"];
    $MSTimeparams["MSB_Detail_UsedMW"] = (trim($MSTimeparams["MSB_Detail_UsedMW"]) == "") ? 0 : $MSTimeparams["MSB_Detail_UsedMW"];
    $MSTimeparams["MSB_Detail_UsedWE"] = (trim($MSTimeparams["MSB_Detail_UsedWE"]) == "") ? 0 : $MSTimeparams["MSB_Detail_UsedWE"];

    $UsedFullweek = $MSTimeparams["Booking_Full_Week"] + $MSTimeparams["MSB_Detail_UsedFW"];
    $UsedMidweek = $MSTimeparams["Booking_Mid_Week"] + $MSTimeparams["MSB_Detail_UsedMW"];
    $UsedWeekend = $MSTimeparams["Booking_Weekend"] + $MSTimeparams["MSB_Detail_UsedWE"];

    $Total = $Total - $UsedFullweek;
    while ($Total > 0 and ($UsedMidweek > 0 or $UsedWeekend > 0)) {
        if ($UsedWeekend > 0 and $UsedMidweek == 0) {
            $UsedWeekend--;
            $LeftMidweek++;
        }
        if ($UsedMidweek > 0 and $UsedWeekend == 0) {
            $UsedMidweek--;
            $LeftWeekend++;
        }
        if ($UsedMidweek > 0 and $UsedWeekend > 0) {
            $UsedMidweek--;
            $UsedWeekend--;
        }
        $Total--;
    }

    $Cfg_Variable["Available"]["FullWeek"] = $Total;
    $Cfg_Variable["Available"]["MidWeek"] = $LeftMidweek;
    $Cfg_Variable["Available"]["Weekend"] = $LeftWeekend;

    return $Cfg_Variable["Available"];
}

/**
 * 转换日期
 * @param $date
 * @param string $format
 * @param string $def_value
 * @return string
 */
function format_date($date, $format = 'd/m/Y', $def_value = '-')
{
    if (empty($date) || $date == '0000-00-00' || $date == '0000-00-00 00:00:00') {
        return $def_value;
    }
    $time = strtotime($date);
    if (empty($time)) {
        return $def_value;
    }
    return date($format, $time);
}

function chinesedate($date)
{
    if (empty($date)) {
        return '';
    }
    list ($DD, $MM, $YYYY) = preg_split('/[\/.-]/', $date);
    return $YYYY . "&#24180;" . $MM . "&#26376;" . $DD . "&#26085;";
}

function space($str)
{
    //ไม่เอาวินาที
    if ($str == null or $str == "0" or $str == "00/00/0000" or $str == "0000-00-00" or preg_match('/0, 0000/i', $str) or preg_match('/--/i', $str)) {
        $result = "-";
    } else {
        $result = $str;
    }
    return $result;
}

function thaidate($date, $format)
{
    if (empty($date)) {
        return '';
    }
    $thmonths = array("", "มกราคม", "กุมภาพันธ์", "มีนาคม", "เมษายน", "พฤษภาคม", "มิถุนายน", "กรกฎาคม", "สิงหาคม", "กันยายน", "ตุลาคม", "พฤศจิกายน", "ธันวาคม");
    $thmonths_s = array("", "ม.ค.", "ก.พ.", "มี.ค.", "เม.ย.", "พ.ค.", "มิ.ย.", "ก.ค.", "ส.ค.", "ก.ย.", "ต.ค.", "พ.ย.", "ธ.ค.");
    list ($DD, $MM, $YYYY) = preg_split('/[\/.-]/', $date);
    if ($format == "long") {
        $result = $DD . " " . $thmonths[(int)$MM] . " " . ($YYYY + 543);
    } else if ($format == "short") {
        $result = $DD . " " . $thmonths_s[(int)$MM] . " " . ($YYYY + 543);
    } else {
        $result = $DD . "/" . $MM . "/" . ($YYYY + 543);
    }
    return $result;
}

function convert_date_to_YYYYMMDD($date)
{
    if (empty($date)) {
        return '';
    }
    list ($DD, $MM, $YYYY) = preg_split('/[\/.-]/', $date);
    return "$YYYY-$MM-$DD";
}

function convert_date($date)
{
    if (empty($date)) {
        return '';
    }
    $engmonths = array("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");
    list ($y, $m, $d) = preg_split('/[\/.-]/', $date);
    $em = $engmonths[$m - 1];
    return $d . '-' . $em . '-' . $y;
}

function unbr($string)
{
    return str_replace('<br />', '<br>', $string);
}


function get_max_package_year($package_id, $membership_id, $start_advance_year)
{
    $start_advance_year = 2021;
    $sql = "         SELECT 
					   MBSD.ms_detail_year				AS    year
			        ,  PKP.packageprice_prices			AS	package_1year_price 
					,  PKP.packageprice_amount1		AS	amount1
					,  PKP.packageprice_prices1		AS	price1
					,  PKP.packageprice_amount2		AS	amount2
					,  PKP.packageprice_prices2		AS	price2 
					,  PKP.packageprice_amount3		AS	amount3
					,  PKP.packageprice_prices3		AS	price3
					,  PKP.packageprice_amount4		AS	amount4
					,  PKP.packageprice_prices4		AS	price4
					,  PKP.packageprice_amount5		AS	amount5
					,  PKP.packageprice_prices5		AS	price5 
					,  DATE_FORMAT(MBSD.ms_detail_paid_date,'%d/%m/%Y') AS paid_date
					,  MBSD.paid_amount					AS	paid_amount
					,  MBSD.paid_method					AS	paid_method 
					,  MBSD.total_week						AS	week_per_year
					,  MBSD.ms_detail_paid				AS	paid_status
					,  MBSD.paid_status					AS	paid_completed
					,  PK.packageid							AS	package_id 
					,  PK.packagename						AS	package_name
					,  MBSD.ms_detail_id					AS	 ms_detail_id 
				FROM package PK 
						INNER JOIN packageprice PKP 
							ON PKP.packageid = PK.packageid
						INNER JOIN membership_detail MBSD 
							ON PK.packageid = MBSD.packageid AND PKP.packageprice_years = MBSD.ms_detail_year
						INNER JOIN hierarchy H 
							ON H.hierarchyid = MBSD.hierarchyid 
			WHERE PKP.packageid='" . $package_id . "'
					AND MBSD.hierarchyid='" . $membership_id . "' 
					AND PKP.packageprice_years='" . $start_advance_year . "'   
					ORDER BY MBSD.ms_detail_year ASC
			";

    $rs = Db::query($sql);
    if (empty($rs[0])) {
        return [];
    }
    $row = $rs[0];


    $result['week_per_year'] = $row['week_per_year'];
    $result['package_name'] = $row['package_name'];
    $result['package_id'] = $row['package_id'];

    $result['package_1year_price'] = $row['package_1year_price'];

    if ($row['amount5'] && $row['amount5'] != 0 && $row['amount5'] != "") {
        $result['max_package_advance_year'] = $row['amount5'];
    } elseif ($row['amount4'] && $row['amount4'] != 0 && $row['amount4'] != "") {
        $result['max_package_advance_year'] = $row['amount4'];
    } elseif ($row['amount3'] && $row['amount3'] != 0 && $row['amount3'] != "") {
        $result['max_package_advance_year'] = $row['amount3'];
    } elseif ($row['amount2'] && $row['amount2'] != 0 && $row['amount2'] != "") {
        $result['max_package_advance_year'] = $row['amount2'];
    } elseif ($row['amount1'] && $row['amount1'] != 0 && $row['amount1'] != "") {
        $result['max_package_advance_year'] = $row['amount1'];
    } else {
        $result['max_package_advance_year'] = 1;
    }

    $result['max_range_book_advance_year'] = 1;

    // ¨Ó¹Ç¹ Range ¢Í§¡ÒÃ¨Í§ÅèÇ§Ë¹éÒÇèÒÁÕ¡ÕèªèÇ§ (ÊÙ§ÊØ´ 5 ªèÇ§ à¾ÃÒÐÁÕ¿ÔÅ´ìá¤è¹Ñé¹ )


    if ($row['package_1year_price'] && $row['package_1year_price'] != 0 && $row['package_1year_price'] != "") {

        $result['total_advance_year'][0] = 1;

    }


    if ($row['amount1'] && $row['amount1'] != 0 && $row['amount1'] != "") {
        $result['max_range_book_advance_year']++;
        $result['total_advance_year'][1] = $row['amount1'];
        $result['package_price'][1] = $row['price1'];

    }
    if ($row['amount2'] && $row['amount2'] != 0 && $row['amount2'] != "") {
        $result['max_range_book_advance_year']++;
        $result['total_advance_year'][2] = $row['amount2'];
        $result['package_price'][2] = $row['price2'];

    }
    if ($row['amount3'] && $row['amount3'] != 0 && $row['amount3'] != "") {
        $result['max_range_book_advance_year']++;
        $result['total_advance_year'][3] = $row['amount3'];
        $result['package_price'][3] = $row['price3'];
    }
    if ($row['amount4'] && $row['amount4'] != 0 && $row['amount4'] != "") {
        $result['max_range_book_advance_year']++;
        $result['total_advance_year'][4] = $row['amount4'];
        $result['package_price'][4] = $row['price4'];
    }
    if ($row['amount5'] && $row['amount5'] != 0 && $row['amount5'] != "") {
        $result['max_range_book_advance_year']++;
        $result['total_advance_year'][5] = $row['amount5'];
        $result['package_price'][5] = $row['price5'];
    }
    return $result;
}

/**
 * 转换时间
 * @param $str
 * @return string
 */
function convertdate2db($str)
{
    if (empty($str)) {
        return '0000-00-00';
    }
    list($day, $month, $year) = explode("/", $str);
    return $year . "-" . $month . "-" . $day;
}

/**
 * 添加记录
 * @param $ms_detail_id
 * @param $paid_amount
 * @param $paid_method
 * @param $paid_type
 * @param $paid_status
 * @param $invoice_bank
 * @return void
 */
function PaymentRecorde($ms_detail_id, $paid_amount, $paid_method, $paid_type, $paid_status = "Y", $invoice_bank = "")
{
    $sql = "
				SELECT
					MSD.ms_detail_id
					, MSD.memberid
					, MSD.hierarchyid
					, MSD.packageid
					, MSD.partnerid
					, MSD.ms_detail_year
					, MSD.special_amount
				    , MSD.paid_remark

					, MB.login_name AS member_name
					, MB.login_surname AS member_surname

					, HR.contract_no
					, HR.servicetype
					, HR.season_type
					, HR.FYO
					, HR.LYO
				
					, PK.packagename
					, PK.unittype
					, PK.weeks
				
					, PKP.packagepriceid
					, PKP.packageprice_years
					, PKP.packageprice_prices	
				FROM membership_detail MSD
				LEFT JOIN member MB ON MB.memberid = MSD.memberid
				LEFT JOIN hierarchy HR ON HR.hierarchyid = MSD.hierarchyid
				LEFT JOIN package PK ON PK.packageid = MSD.packageid
				LEFT JOIN packageprice PKP ON PKP.packageid = PK.packageid AND PKP.packageprice_years = MSD.ms_detail_year
				WHERE MSD.ms_detail_id = " . $ms_detail_id . "
			";
    $query = Db::query($sql);
    if (!empty($query[0])) {
        $row = $query[0];
    } else {
        $row = [];
    }
    $row['paid_amount'] = $paid_amount;
    $row['paid_method'] = $paid_method;
    $row['paid_type'] = $paid_type;
    $row['invoice_bank'] = $invoice_bank;
    $row['paid_status'] = $paid_status;
    $row['created_on'] = date('Y-m-d H:i:s');
    Record::create($row);
}


function GetExtraNightDetail($OrderId, $status_paid = NULL, $extra_paid = NULL, $status_booking = NULL, $status_renounce = NULL)
{
    $sql_extra = "	SELECT 
							orders_extra_id, 
							orders_code, 
							extra_unittype, 
							checkin_date, 
							checkout_date, 
							DATE_FORMAT(checkin_date,'%e %b %y') AS txt_ci_date, 
							DATE_FORMAT(checkout_date,'%e %b %y') AS txt_co_date, 
							room_amount, 
							extra_price,
							extranight, 
							grand_total, 
							extra_paid_amount, 
							remark,
							createdate 
						FROM 
							orders_extra 
						WHERE 
							orders_id=" . $OrderId;
    if (isset($status_paid) and $status_paid != NULL) {
        $sql_extra .= " AND status_paid='" . $status_paid . "'";
    }
    if (isset($extra_paid) and $extra_paid != NULL) {
        $sql_extra .= " AND extra_paid='" . $extra_paid . "'";
    }
    if (isset($status_renounce) and $status_renounce != NULL) {
        $sql_extra .= " AND status_renounce='" . $status_renounce . "'";
    } else {
        $sql_extra .= " AND ISNULL(status_renounce)";
    }
    if (isset($status_booking) and $status_booking != NULL) {
        $sql_extra .= " AND status_booking='" . $status_booking . "'";
    } else {
        $sql_extra .= " AND ISNULL(status_booking)";
    }
    return Db::query($sql_extra);
}

function GetBonusDetail($OrderId, $status_paid = NULL, $bonus_paid = NULL, $status_booking = NULL, $status_renounce = NULL)
{
    $sql_bonus = "	SELECT 
							OB.orders_bonus_id, 
							OB.orders_code, 
							OB.bonus_type, 
							OB.resortid, 
							resort.resortname, 
							OB.bonus_price, 
							OB.bonus_unittype, 
							OB.checkin_date, 
							OB.checkout_date, 
							DATE_FORMAT(OB.checkin_date,'%e %b %y') AS txt_ci_date, 
							DATE_FORMAT(OB.checkout_date,'%e %b %y') AS txt_co_date, 
							OB.room_amount, 
							OB.bonus_fullweek, 
							OB.bonus_midweek, 
							OB.bonus_weekend, 
							OB.bonus_extranight, 
							OB.grand_total, 
							OB.bonus_paid_amount, 
							OB.remark,
							OB.createdate						
						FROM orders_bonus AS OB 
						LEFT OUTER JOIN resort ON
							resort.resortid=OB.resortid
						WHERE 
							OB.orders_id=" . $OrderId;
    if (isset($status_paid) and $status_paid != NULL) {
        $sql_bonus .= " AND OB.status_paid='" . $status_paid . "'";
    }
    if (isset($bonus_paid) and $bonus_paid != NULL) {
        $sql_bonus .= " AND OB.bonus_paid='" . $bonus_paid . "'";
    }
    if (isset($status_renounce) and $status_renounce != NULL) {
        $sql_bonus .= " AND OB.status_renounce='" . $status_renounce . "'";
    } else {
        $sql_bonus .= " AND ISNULL(OB.status_renounce)";
    }
    if (isset($status_booking) and $status_booking != NULL) {
        $sql_bonus .= " AND OB.status_booking='" . $status_booking . "'";
    } else {
        $sql_bonus .= " AND ISNULL(OB.status_booking)";
    }
    return Db::query($sql_bonus);
}

function GetExchangeDetail($OrderId, $status_paid = NULL, $van_paid = NULL, $status_booking = NULL, $status_renounce = NULL)
{
    $sql_van = "	SELECT 
							van.orders_van_id, 
							van.orders_code, 
							van.from_contract AS from_contact, 
							van.from_year,
							van.from_unittype, 
							van.from_fullweek, 
							van.from_midweek, 
							van.from_weekend, 
							resort.resortname, 
							van.to_unittype, 
							van.room_amount, 
							van.to_fullweek, 
							van.to_midweek, 
							van.to_weekend, 
							van.checkin_date,
							van.checkout_date,
							DATE_FORMAT(van.checkin_date,'%e %b %y') AS txt_ci_date, 
							DATE_FORMAT(van.checkout_date,'%e %b %y') AS txt_co_date, 
							van.van_fee,
							van.grand_total,
							van.van_paid_amount, 
							van.remark,
							van.createdate
						FROM orders_van AS van 
						LEFT OUTER JOIN resort ON
							resort.resortid=van.resortid
						WHERE 
							van.orders_id=" . $OrderId;
    if (isset($status_paid) and $status_paid != NULL) {
        $sql_van .= " AND van.status_paid='" . $status_paid . "'";
    }
    if (isset($van_paid) and $van_paid != NULL) {
        $sql_van .= " AND van.van_paid='" . $van_paid . "'";
    }
    if (isset($status_renounce) and $status_renounce != NULL) {
        $sql_van .= " AND van.status_renounce='" . $status_renounce . "'";
    } else {
        $sql_van .= " AND ISNULL(van.status_renounce)";
    }
    if (isset($status_booking) and $status_booking != NULL) {
        $sql_van .= " AND van.status_booking='" . $status_booking . "'";
    } else {
        $sql_van .= " AND ISNULL(van.status_booking)";
    }
    return Db::query($sql_van);
}

function GetAdditionDetail($OrderId, $status_paid = NULL, $addi_paid = NULL, $status_booking = NULL, $status_renounce = NULL)
{
    $sql_addi = "	SELECT 
							orders_addi_id, 
							orders_code, 
							addi_rate_id, 
							addi_rate_name, 
							addi_rate_price,
							addi_unit,
							grand_total, 
							addi_paid_amount,
							remark,
							createdate
						FROM 
							orders_addi 
						WHERE 
							orders_id=" . $OrderId;
    if (isset($status_paid) and $status_paid != NULL) {
        $sql_addi .= " AND status_paid='" . $status_paid . "'";
    }
    if (isset($addi_paid) and $addi_paid != NULL) {
        $sql_addi .= " AND addi_paid='" . $addi_paid . "'";
    }
    if (isset($status_renounce) and $status_renounce != NULL) {
        $sql_addi .= " AND status_renounce='" . $status_renounce . "'";
    } else {
        $sql_addi .= " AND ISNULL(status_renounce)";
    }
    if (isset($status_booking) and $status_booking != NULL) {
        $sql_addi .= " AND status_booking='" . $status_booking . "'";
    } else {
        $sql_addi .= " AND ISNULL(status_booking)";
    }
    return Db::query($sql_addi);
}

function getOrderNumber($MemberId)
{
    $sql_order_no = "SELECT MAX(IFNULL(SUBSTRING(orders_no,11),0))+1 AS next_no, DATE_FORMAT(NOW(),'%Y%m%d') AS today_date FROM orders WHERE DATE_FORMAT(createdate,'%Y')=DATE_FORMAT(NOW(),'%Y')";
    $rs_order_no = Db::query($sql_order_no);
    if (empty($rs_order_no[0])) {
        return '';
    }
    $row_order_no = $rs_order_no[0];
    $freq_id = $row_order_no['today_date'] . "-" . sprintf("%04d", $row_order_no['next_no']);

    $sql_order_no = "SELECT member_type FROM member WHERE memberid='" . $MemberId . "'";
    $rs_order_no = Db::query($sql_order_no);
    $row_order_no = $rs_order_no[0];

    return $row_order_no['member_type'] . $freq_id;
}

function ORDERS_GenCode($OrderType, $OrderID)
{
    return sprintf("Q%04d%02d%02d-%s-%04d", date('Y'), date('m'), date('d'), $OrderType, $OrderID);
}

function CountOrderDetail($OrderId, $status = NULL)
{
    $count = array();
    $sql_count = "	SELECT
							O.orders_id,
							COUNT(DT.orders_extra_id) AS NUM_detail
						FROM orders O
						LEFT OUTER JOIN orders_extra DT ON
							DT.orders_id=O.orders_id";

    if ($status != NULL) {
        switch ($status) {
            case "NotPaid"    :
                $sql_count .= " AND (DT.status_paid='' OR ISNULL(DT.status_paid))";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "Wait"        :
                $sql_count .= " AND DT.status_paid='W'";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "Paid"        :
                $sql_count .= " AND DT.status_paid='P'";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "PaidCompleted"        :
                $sql_count .= " AND DT.extra_paid='Y'";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "Booked"    :
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND DT.status_booking='F'";
                break;
            case "Used"    :
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND DT.status_booking='U'";
                break;
            case "Renounce"    :
                $sql_count .= " AND (DT.status_renounce='A' OR DT.status_renounce='B')";
                break;
        }
    } else {
        $sql_count .= " AND ISNULL(DT.status_renounce)";
        $sql_count .= " AND ISNULL(DT.status_booking)";
    }

    $sql_count .= "	GROUP BY O.orders_id
						HAVING O.orders_id=" . $OrderId;

    $rs_count = Db::query($sql_count);
    $row_count = $rs_count[0] ?? [];
    $count['orders_extra'] = $row_count['NUM_detail'] ?? 0;

    $sql_count = "	SELECT
							O.orders_id,
							COUNT(DT.orders_bonus_id) AS NUM_detail
						FROM orders O
						LEFT OUTER JOIN orders_bonus DT ON
							DT.orders_id=O.orders_id";

    if ($status != NULL) {
        switch ($status) {
            case "NotPaid"    :
                $sql_count .= " AND (DT.status_paid='' OR ISNULL(DT.status_paid))";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "Wait"        :
                $sql_count .= " AND DT.status_paid='W'";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "Paid"        :
                $sql_count .= " AND DT.status_paid='P'";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "PaidCompleted"        :
                $sql_count .= " AND DT.bonus_paid='Y'";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "Booked"    :
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND DT.status_booking='F'";
                break;
            case "Used"    :
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND DT.status_booking='U'";
                break;
            case "Renounce"    :
                $sql_count .= " AND (DT.status_renounce='A' OR DT.status_renounce='B')";
                break;
        }
    } else {
        $sql_count .= " AND ISNULL(DT.status_renounce)";
        $sql_count .= " AND ISNULL(DT.status_booking)";
    }

    $sql_count .= "	GROUP BY O.orders_id
						HAVING O.orders_id=" . $OrderId;

    $rs_count = Db::query($sql_count);
    $row_count = $rs_count[0] ?? [];
    $count['orders_bonus'] = $row_count['NUM_detail'] ?? 0;

    $sql_count = "	SELECT
							O.orders_id,
							COUNT(DT.orders_van_id) AS NUM_detail
						FROM orders O
						LEFT OUTER JOIN orders_van DT ON
							DT.orders_id=O.orders_id";

    if ($status != NULL) {
        switch ($status) {
            case "NotPaid"    :
                $sql_count .= " AND (DT.status_paid='' OR ISNULL(DT.status_paid))";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "Wait"        :
                $sql_count .= " AND DT.status_paid='W'";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "Paid"        :
                $sql_count .= " AND DT.status_paid='P'";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "PaidCompleted"        :
                $sql_count .= " AND DT.van_paid='Y'";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "Booked"    :
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND DT.status_booking='F'";
                break;
            case "Used"    :
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND DT.status_booking='U'";
                break;
            case "Renounce"    :
                $sql_count .= " AND (DT.status_renounce='A' OR DT.status_renounce='B')";
                break;
        }
    } else {
        $sql_count .= " AND ISNULL(DT.status_renounce)";
        $sql_count .= " AND ISNULL(DT.status_booking)";
    }

    $sql_count .= "	GROUP BY O.orders_id
						HAVING O.orders_id=" . $OrderId;

    $rs_count = Db::query($sql_count);
    $row_count = $rs_count[0] ?? [];
    $count['orders_van'] = $row_count['NUM_detail'] ?? 0;

    $sql_count = "	SELECT
							O.orders_id,
							COUNT(DT.orders_addi_id) AS NUM_detail
						FROM orders O
						LEFT OUTER JOIN orders_addi DT ON
							DT.orders_id=O.orders_id";

    if ($status != NULL) {
        switch ($status) {
            case "NotPaid"    :
                $sql_count .= " AND (DT.status_paid='' OR ISNULL(DT.status_paid))";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "Wait"        :
                $sql_count .= " AND DT.status_paid='W'";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "Paid"        :
                $sql_count .= " AND DT.status_paid='P'";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "PaidCompleted"        :
                $sql_count .= " AND DT.addi_paid='Y'";
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND ISNULL(DT.status_booking)";
                break;
            case "Booked"    :
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND DT.status_booking='F'";
                break;
            case "Used"    :
                $sql_count .= " AND ISNULL(DT.status_renounce)";
                $sql_count .= " AND DT.status_booking='U'";
                break;
            case "Renounce"    :
                $sql_count .= " AND (DT.status_renounce='A' OR DT.status_renounce='B')";
                break;
        }
    } else {
        $sql_count .= " AND ISNULL(DT.status_renounce)";
        $sql_count .= " AND ISNULL(DT.status_booking)";
    }

    $sql_count .= "	GROUP BY O.orders_id
						HAVING O.orders_id=" . $OrderId;

    $rs_count = Db::query($sql_count);
    $row_count = $rs_count[0] ?? [];
    $count['orders_addi'] = $row_count['NUM_detail'] ?? 0;

    return $count;
}

function DuplicateOrder($OldOrderID, $MemberID = 0)
{
    $orders = new Orders();

    $row_select = $orders->where('orders_id', $OldOrderID)->find();

    if (empty($row_select)) {
        return false;
    }
    if (empty($MemberID)) {
        $MemberID = $row_select['memberid'];
    }
    $auth = Auth::instance();

    $orders->where('orders_id', $OldOrderID)->update([
        'status_new' => 'D',
        'cancel_date' => date('Y-m-d H:i:s'),
        'updateby' => $auth->username,
        'updatedate' => date('Y-m-d H:i:s'),
    ]);


    $OrderNo = getOrderNumber($MemberID);

    $sql = "
		INSERT INTO orders(
			orders.memberid,
			orders.orders_date,
			orders.orders_no,
			orders.doc_no,
			orders.checkin_date,
			orders.checkout_date,
			orders.due_date,
			orders.remark,
			orders.createby,
			orders.createdate
		) VALUES(
			'" . $MemberID . "',
			NOW(),
			'" . $OrderNo . "',
			'" . $row_select['doc_no'] . "',
			'" . $row_select['checkin_date'] . "',
			'" . $row_select['checkout_date'] . "',
			'" . $row_select['due_date'] . "',
			'" . $row_select['remark'] . "',
			'" . $auth->username . "',
			NOW()
		)
		";
    Db::execute($sql);

    $OrderID = Db::getLastInsID();

    $sql_select = "SELECT member_type FROM member WHERE memberid='" . $MemberID . "'";
    $rs_select = Db::query($sql_select);
    $row_select = $rs_select[0];
    $OrderType = $row_select['member_type'];

    $Code = ORDERS_GenCode($OrderType, $OrderID);

    $sql = "
		UPDATE orders SET 
			orders.orders_code='" . $Code . "' 
		WHERE 
			orders.orders_id='" . $OrderID . "'
		";
    Db::execute($sql);

    $count = CountOrderDetail($OldOrderID);

    if ($count["orders_extra"] > 0) {
        $rs_select = GetExtraNightDetail($OldOrderID);
        foreach ($rs_select as $row_select) {
            $sql_insert = "
					INSERT INTO orders_extra(
						orders_id,
						extra_unittype,
						checkin_date,
						checkout_date,
						room_amount,
						extra_price,
						extranight,
						grand_total,
						remark,
						createby,
						createdate
					) VALUES(
						'" . $OrderID . "',
						'" . $row_select["extra_unittype"] . "',
						'" . $row_select["checkin_date"] . "',
						'" . $row_select["checkout_date"] . "',
						'" . $row_select["room_amount"] . "',
						'" . $row_select["extra_price"] . "',
						'" . $row_select["extranight"] . "',
						'" . $row_select["grand_total"] . "',
						'" . $row_select["remark"] . "',
						'" . $auth->username . "',
						NOW()
					)";
            Db::execute($sql_insert);
            $order_detail_id = Db::getLastInsID();

            $sql_update = "UPDATE orders_extra SET orders_code='e" . sprintf("%011d", $order_detail_id) . "' WHERE orders_extra_id='" . $order_detail_id . "'";
            Db::execute($sql_update);
        }
    }
    if ($count["orders_bonus"] > 0) {
        $rs_select = GetBonusDetail($OldOrderID);
        foreach ($rs_select as $row_select) {
            $sql_insert = "
				INSERT INTO orders_bonus(
					orders_id,
					resortid,
					bonus_type,
					bonus_unittype,
					checkin_date,
					checkout_date,
					room_amount,
					bonus_weekend,
					bonus_midweek,
					bonus_fullweek,
					bonus_extranight,
					bonus_price,
					grand_total,
					remark,
					createby,
					createdate
					) 
					VALUES(
					'" . $OrderID . "',
					'" . $row_select["resortid"] . "',
					'" . $row_select["bonus_type"] . "',
					'" . $row_select["bonus_unittype"] . "',
					'" . $row_select["checkin_date"] . "',
					'" . $row_select["checkout_date"] . "',
					'" . $row_select["room_amount"] . "',
					'" . $row_select["bonus_weekend"] . "',
					'" . $row_select["bonus_midweek"] . "',
					'" . $row_select["bonus_fullweek"] . "',
					'" . $row_select["bonus_extranight"] . "',
					'" . $row_select["bonus_price"] . "',
					'" . $row_select["grand_total"] . "',
					'" . $row_select["remark"] . "',
					'" . $auth->username . "',
					NOW()
					)";
            Db::execute($sql_insert);
            $order_detail_id = Db::getLastInsID();

            $sql_update = "UPDATE orders_bonus SET orders_code='b" . sprintf("%011d", $order_detail_id) . "' WHERE orders_bonus_id='" . $order_detail_id . "'";
            Db::execute($sql_update);
        }
    }
    if ($count["orders_van"] > 0) {
        $rs_select = GetExchangeDetail($OldOrderID);
        foreach ($rs_select as $row_select) {
            $sql_insert = "
				INSERT INTO orders_van(
					orders_id,
					from_contract,
					from_year,
					from_unittype,
					from_fullweek,
					from_midweek,
					from_weekend,
					resortid,
					to_unittype,
					to_fullweek,
					to_midweek,
					to_weekend,
					checkin_date,
					checkout_date,
					room_amount,
					van_fee,
					grand_total,
					remark,
					createby,
					createdate
					)  VALUES(
					'" . $OrderID . "',
					'" . $row_select["from_contact"] . "',
					'" . $row_select["from_year"] . "',
					'" . $row_select["from_unittype"] . "',
					'" . $row_select["from_fullweek"] . "',
					'" . $row_select["from_midweek"] . "',
					'" . $row_select["from_weekend"] . "',
					'" . $row_select["resortid"] . "',
					'" . $row_select["to_unittype"] . "',
					'" . $row_select["to_fullweek"] . "',
					'" . $row_select["to_midweek"] . "',
					'" . $row_select["to_weekend"] . "',
					'" . $row_select["checkin_date"] . "' ,
					'" . $row_select["checkout_date"] . "' ,
					'" . $row_select["room_amount"] . "' ,
					'" . $row_select["van_fee"] . "' ,
					'" . $row_select["grand_total"] . "' ,
					'" . $row_select["remark"] . "' ,
					'" . $auth->username . "',
					NOW()
					)";
            Db::execute($sql_insert);
            $order_detail_id = Db::getLastInsID();

            $sql_update = "UPDATE orders_van SET orders_code='v" . sprintf("%011d", $order_detail_id) . "' WHERE orders_van_id='" . $order_detail_id . "'";
            Db::execute($sql_update);
        }
    }
    if ($count["orders_addi"] > 0) {
        $rs_select = GetAdditionDetail($OldOrderID);
        foreach ($rs_select as $row_select) {
            $sql_insert = "	INSERT INTO orders_addi(
									orders_id,
									addi_rate_id,
									addi_rate_name,
									addi_rate_price,
									addi_unit,
									grand_total,
									remark,
									createby,
									createdate)
								VALUES (
									'" . $OrderID . "',
									'" . $row_select['addi_rate_id'] . "',
									'" . $row_select['addi_rate_name'] . "',
									'" . $row_select['addi_rate_price'] . "',
									'" . $row_select['addi_unit'] . "',
									'" . $row_select['grand_total'] . "',
									'" . $row_select['remark'] . "',
									'" . $auth->username . "',
									NOW() ) ";
            Db::execute($sql_insert);
            $order_detail_id = Db::getLastInsID();

            $sql_update = "UPDATE orders_addi SET orders_code='a" . sprintf("%011d", $order_detail_id) . "' WHERE orders_addi_id=" . $order_detail_id;
            Db::execute($sql_update);
        }
    }

    return true;
}

function CancelOrder($OrderId)
{
    $orders = new Orders();
    $row_select = $orders->where('orders_id', $OrderId)->find();

    if (empty($row_select)) {
        return false;
    }
    $auth = Auth::instance();
    $orders->where('orders_id', $OrderId)->update([
        'status_new' => 'C',
        'cancel_date' => date('Y-m-d H:i:s'),
        'updateby' => $auth->username,
        'updatedate' => date('Y-m-d H:i:s'),
    ]);
    return true;
}

function ConfirmAccount($OrderId)
{
    $orders = new Orders();
    $auth = Auth::instance();
    $orders->where('orders_id', $OrderId)->update([
        'account_confirm' => 'Y',
        'updateby' => $auth->username,
        'updatedate' => date('Y-m-d H:i:s'),
    ]);
}

function DeleteOrder($orders_id)
{
    $orders = new Orders();
    $row_select = $orders->where('orders_id', $orders_id)->find();

    if (empty($row_select)) {
        return false;
    }
    Db::execute("DELETE FROM orders_addi WHERE orders_id=" . $orders_id);
    Db::execute("DELETE FROM orders_bonus WHERE orders_id=" . $orders_id);
    Db::execute("DELETE FROM orders_extra WHERE orders_id=" . $orders_id);
    Db::execute("DELETE FROM orders_van WHERE orders_id=" . $orders_id);
    Db::execute("DELETE FROM orders WHERE orders_id=" . $orders_id);
    return true;
}

function RenounceOrder($orders_id)
{
    $orders = new Orders();

    $orders_addi = new Addi();
    $orders_bonus = new Bonus();
    $orders_extra = new Extra();
    $orders_van = new Van();

    $orders_extra_list = $orders_extra->where('orders_id', $orders_id)->select();
    if (!empty($orders_extra_list)) {
        foreach ($orders_extra_list as $v) {
            $orders_extra->where('orders_extra_id', $v['orders_extra_id'])->update([
                'status_renounce' => 'A'
            ]);
        }
    }
    $orders_bonus_list = $orders_bonus->where('orders_id', $orders_id)->select();
    if (!empty($orders_bonus_list)) {
        foreach ($orders_bonus_list as $v) {
            $orders_bonus->where('orders_bonus_id', $v['orders_bonus_id'])->update([
                'status_renounce' => 'A'
            ]);
        }
    }
    $orders_van_list = $orders_van->where('orders_id', $orders_id)->select();
    if (!empty($orders_van_list)) {
        foreach ($orders_van_list as $v) {
            $orders_van->where('orders_van_id', $v['orders_van_id'])->update([
                'status_renounce' => 'A'
            ]);
        }
    }
    $orders_eaddi_list = $orders_addi->where('orders_id', $orders_id)->select();

    if (!empty($orders_eaddi_list)) {
        foreach ($orders_eaddi_list as $v) {
            $orders_addi->where('orders_addi_id', $v['orders_addi_id'])->update([
                'status_renounce' => 'A'
            ]);
        }
    }

    $Count_All = CountOrderDetail($orders_id, "All");
    $Count_Renounce = CountOrderDetail($orders_id, "Renounce");
    $Count_Used = CountOrderDetail($orders_id, "Used");

    $completed = 'Y';
    if ($Count_Renounce['orders_extra'] + $Count_Used['orders_extra'] != $Count_All['orders_extra']) $completed = 'N';
    if ($Count_Renounce['orders_bonus'] + $Count_Used['orders_bonus'] != $Count_All['orders_bonus']) $completed = 'N';
    if ($Count_Renounce['orders_van'] + $Count_Used['orders_van'] != $Count_All['orders_van']) $completed = 'N';
    if ($Count_Renounce['orders_addi'] + $Count_Used['orders_addi'] != $Count_All['orders_addi']) $completed = 'N';

    $orders_renounce = 'A';
    if ($Count_Renounce['orders_extra'] != $Count_All['orders_extra']) $orders_renounce = 'O';
    if ($Count_Renounce['orders_bonus'] != $Count_All['orders_bonus']) $orders_renounce = 'O';
    if ($Count_Renounce['orders_van'] != $Count_All['orders_van']) $orders_renounce = 'O';
    if ($Count_Renounce['orders_addi'] != $Count_All['orders_addi']) $orders_renounce = 'O';

    $orders->where('orders_id', $orders_id)->update([
        'orders_renounce' => $orders_renounce,
        'completed' => $completed,
        'completed_date' => date('Y-m-d H:i:s')
    ]);
}

function money($money, $decimals = 2, $dec_point = '.', $thousands_sep = ',')
{
    if (empty($money)) {
        return 0.00;
    }
    return number_format((float)$money, $decimals, $dec_point, $thousands_sep);
}


/**
 * 转换日期(存入数据库里的日期)
 * @param $date
 * @param string $format
 * @param string $def_value
 * @return string
 */
function format_sqldate($date, $format = 'Y-m-d', $def_value = '')
{
    if (empty($date) || $date == '00/00/0000' || $date == '00/00/0000 00:00:00') {
        return $def_value;
    }
    $date = preg_replace('/(\d{2})\/(\d{2})\/(\d{4})/', '${3}-${2}-${1}', $date);
    $time = strtotime($date);
    if (empty($time)) {
        return $def_value;
    }
    return date($format, $time);
}

function DeleteBook($booking_id)
{
    $booking = new Booking();
    $row_select = $booking->where('booking_id', $booking_id)->find();

    if (empty($row_select)) {
        return false;
    }
    Db::execute("DELETE FROM booking_unittype WHERE booking_id=" . $booking_id);
    Db::execute("DELETE FROM binding_main WHERE booking_id=" . $booking_id);
    Db::execute("DELETE FROM booking_unittype WHERE booking_id=" . $booking_id);
    Db::execute("DELETE FROM booking_detail WHERE booking_id=" . $booking_id);
    Db::execute("DELETE FROM booking WHERE booking_id=" . $booking_id);
    return true;
}

function GetArrayBookingDetailID($booking_id)
{
    $sql = "SELECT booking_detail_id FROM booking_detail WHERE booking_id ='" . $booking_id . "'";
    $rs = Db::query($sql);
    if (!empty($rs)) {
        return array_column($rs, 'booking_detail_id');
    }
    return [];
}

function ReturnDetailStatus($booking_id)
{
    $aBooking['total_booking_detail_id'] = GetArrayBookingDetailID($booking_id);
    if (!empty($aBooking['total_booking_detail_id'])) {
        $sql = "
			SELECT
				Binding.booking_detail_id
				,Binding.orders_code
				,BD.booking_detail_fullweek AS FW
				,BD.booking_detail_midweek AS MW
				,BD.booking_detail_weekend AS WE
				,BD.room
			FROM
				binding_detail Binding
			INNER JOIN booking_detail BD ON
				BD.booking_detail_id = Binding.booking_detail_id
			";
        foreach ($aBooking['total_booking_detail_id'] as $k => $booking_detail_id) {
            if ($k == 0) {
                $sql .= " WHERE (Binding.booking_detail_id='" . $booking_detail_id . "'";
            } else {
                $sql .= " OR Binding.booking_detail_id='" . $booking_detail_id . "'";
            }
        }
        $sql .= ") AND (BD.booking_status='N') ORDER BY BD.booking_detail_id";
        $rs = Db::query($sql);
        $aBooking = array(
            "booking_detail_id" => array(),
            "orders_code" => array(),
            "FW" => array(),
            "MW" => array(),
            "WE" => array(),
            "room" => array()
        );
        if (!empty($rs)) {
            foreach ($rs as $row) {
                $aBooking['booking_detail_id'][] = $row['booking_detail_id'];
                $aBooking['orders_code'][] = $row['orders_code'];
                $aBooking['FW'][] = $row['FW'];
                $aBooking['MW'][] = $row['MW'];
                $aBooking['WE'][] = $row['WE'];
                $aBooking['room'][] = $row['room'];
            }
        }

        foreach ($aBooking['orders_code'] as $k => $orders_code) {
            switch ($orders_code[0]) {
                case "m"    :
                    $sql = "
						SELECT
							Binding.binding_detail_id
						FROM
							binding_detail Binding
						INNER JOIN booking_detail BD ON
							BD.booking_detail_id = Binding.booking_detail_id
						 WHERE
							Binding.orders_code='" . $orders_code . "'
						 ";
                    foreach ($aBooking['booking_detail_id'] as $k => $theID) {
                        $sql .= " AND Binding.booking_detail_id!='" . $theID . "'";
                    }
                    $sql .= " AND BD.booking_status='N' ORDER BY BD.booking_detail_id";
                    $rs = Db::query($sql);
                    if (!empty($rs)) {
                        $status_booking = "K";
                    } else {
                        $status_booking = "N";
                    }

                    $sql_update = "UPDATE membership_detail SET status_booking='" . $status_booking . "' WHERE orders_code='" . $orders_code . "'";
                    Db::execute($sql_update);
                    break;
                case "b"        :
                    $sql_update = "
						UPDATE 
							orders_bonus
						SET
							status_booking = NULL
						WHERE
							orders_code='" . $orders_code . "'
							";
                    Db::update($sql_update);

                    break;
                case "e"        :
                    $sql_update = "
						UPDATE 
							orders_extra
						SET
							status_booking = NULL
						WHERE
							orders_code='" . $orders_code . "'
							";
                    Db::update($sql_update);

                    break;
                case "v"        :
                    $sql_update = "
						UPDATE 
							orders_van
						SET
							status_booking = NULL
						WHERE
							orders_code='" . $orders_code . "'
							";
                    Db::update($sql_update);

                    break;
                case "a"        :
                    $sql_update = "
						UPDATE 
							orders_addi
						SET
							status_booking = NULL
						WHERE
							orders_code='" . $orders_code . "'
							";
                    Db::update($sql_update);

                    break;
            }
        }
    }
    Booking_Cancel($booking_id);
}

function Booking_Cancel($booking_id)
{
    $booking = new Booking();
    $auth = Auth::instance();
    $booking->where('booking_id', $booking_id)->update([
        'booking_status' => 'C',
        'cancel_date' => date('Y-m-d H:i:s'),
        'updateby' => $auth->username,
        'updatedate' => date('Y-m-d H:i:s'),
    ]);
}

function DuplicateBooking($prototypeID, $newConfirmationNo = '')
{
    $booking = new Booking();
    if (empty($newConfirmationNo)) {
        $newConfirmationNo = $booking->where('booking_id', $prototypeID)
            ->value('confirmation_no');
    }
    $auth = Auth::instance();
    $sql = "
		INSERT INTO booking
		(
			confirmation_no
			,memberid
			,hierarchyid
			,booking_method
			,booking_date
			,checkin_date
			,checkout_date
			,booking_weekno
			,note
			,remark
			,createby
			,createdate
		)
		SELECT
			'" . $newConfirmationNo . "'
			,memberid
			,hierarchyid
			,booking_method
			,booking_date
			,checkin_date
			,checkout_date
			,booking_weekno
			,note
			,CONCAT('Duplicated from Confirmation No. : ',confirmation_no)
			,'" . $auth->username . "'
			,NOW()
		FROM booking
		WHERE booking_id = '" . $prototypeID . "'
		";
    Db::execute($sql);

    $newBookingID = Db::getLastInsID();
    $sql = "
		INSERT INTO binding_main
		(
			module_code
			,booking_id
		)
		SELECT
			module_code
			,'" . $newBookingID . "'
		FROM binding_main
		WHERE booking_id = '" . $prototypeID . "'
		";
    Db::execute($sql);

    $sql = "
		INSERT INTO booking_detail
		(
			booking_id
			,resort_id
			,checkin_date
			,checkout_date
			,booking_detail_fullweek
			,booking_detail_midweek
			,booking_detail_weekend
			,booking_detail_extranight
			,booking_detail_unittype
			,room
			,createby
			,createdate
		)
		SELECT
			'" . $newBookingID . "'
			,resort_id
			,checkin_date
			,checkout_date
			,booking_detail_fullweek
			,booking_detail_midweek
			,booking_detail_weekend
			,booking_detail_extranight
			,booking_detail_unittype
			,room
			,'" . $auth->username . "'
			,NOW()
		FROM booking_detail
		WHERE booking_id = '" . $prototypeID . "'
		";
    Db::execute($sql);

    $sql1 = "SELECT booking_detail_id AS old_id FROM booking_detail WHERE booking_id = '" . $prototypeID . "'";
    $rs1 = Db::query($sql1);
    $sql2 = "SELECT booking_detail_id AS new_id FROM booking_detail WHERE booking_id = '" . $newBookingID . "'";
    $rs2 = Db::query($sql2);
    if (!empty($rs1)) {
        foreach ($rs1 as $row1) {
            $oldBookingDetailID = $row1["old_id"];
            $row2 = $rs2[0];
            $newBookingDetailID = $row2["new_id"];
            $sql = "
				INSERT INTO binding_detail
				(
					orders_code
					,booking_detail_id
				)
				SELECT
					orders_code
					,'" . $newBookingDetailID . "'
				FROM binding_detail
				WHERE booking_detail_id = '" . $oldBookingDetailID . "'
				";
            Db::execute($sql);

            $sql = "UPDATE booking_detail SET booking_status='D' WHERE booking_detail_id = '" . $oldBookingDetailID . "'";
            Db::execute($sql);
        }
    }
    $sql = "UPDATE booking SET booking_status='D' WHERE booking_id = '" . $prototypeID . "'";
    Db::execute($sql);
}

function RenounceBooking($BookingId)
{
    $sql_update = "UPDATE booking SET booking_status='B' WHERE booking_id='" . $BookingId . "'";
    Db::execute($sql_update);
    $sql_select = "SELECT module_code FROM binding_main WHERE booking_id='" . $BookingId . "'";
    $rs_select = Db::query($sql_select);
    if (!empty($rs_select)) {
        $aModuleCode = array_column($rs_select, 'module_code');
    } else {
        $aModuleCode = [];
    }

    $sql_select = "SELECT booking_detail_id FROM booking_detail WHERE booking_id='" . $BookingId . "'";
    $rs_select = Db::query($sql_select);
    if (!empty($rs_select)) {
        foreach ($rs_select as $row) {
            $sql_update = "UPDATE booking_detail SET booking_status='F' WHERE booking_detail_id='" . $row['booking_detail_id'] . "'";
            Db::execute($sql_update);

            $sql_select2 = "SELECT orders_code FROM binding_detail WHERE booking_detail_id='" . $row['booking_detail_id'] . "'";
            $rs_select2 = Db::query($sql_select2);
            if (!empty($rs_select2)) {
                foreach ($rs_select2 as $row2) {
                    $module_abv = $row2['orders_code'][0];
                    switch ($module_abv) {
                        case "b"        :
                            $sql_update = "UPDATE orders_bonus SET status_renounce='B' WHERE orders_code='" . $row2['orders_code'] . "'";
                            Db::execute($sql_update);
                            break;
                        case "e"        :
                            $sql_update = "UPDATE orders_extra SET status_renounce='B' WHERE orders_code='" . $row2['orders_code'] . "'";
                            Db::execute($sql_update);
                            break;
                        case "v"        :
                            $sql_update = "UPDATE orders_van SET status_renounce='B' WHERE orders_code='" . $row2['orders_code'] . "'";
                            Db::execute($sql_update);
                            break;
                        case "a"        :
                            $sql_update = "UPDATE orders_addi SET status_renounce='B' WHERE orders_code='" . $row2['orders_code'] . "'";
                            Db::execute($sql_update);
                            break;
                    }
                }
            }
        }

        if (!empty($aModuleCode)) {
            foreach ($aModuleCode as $module_code) {
                $sql_select = "SELECT orders_id FROM orders WHERE orders_code='" . $module_code . "'";
                $rs_select = Db::query($sql_select);
                if (!empty($rs_select)) {
                    $row_select = $rs_select[0];
                    $OrderId = $row_select['orders_id'];
                    $countUsed = CountOrderDetail($OrderId, 'Used');
                    $countPaid = CountOrderDetail($OrderId, 'PaidCompleted');
                    $countBooked = CountOrderDetail($OrderId, 'Booked');
                    if (array_sum($countUsed) == 0 && array_sum($countPaid) == 0 && array_sum($countBooked) == 0) {
                        $booking_renounce = "B";
                    } else {
                        $booking_renounce = "S";
                    }
                    $sql_update = "UPDATE orders SET booking_renounce='" . $booking_renounce . "' WHERE orders_id='" . $OrderId . "'";
                    Db::execute($sql_update);
                }
            }
        }

    }
}

function stamp2date($value)
{
    if (!empty($value)) {
        $value = date('M j, Y', $value);
    } else {
        $value = " - ";
    }
    return $value;
}

function genInvoiceNo($member_id,$prefix="INV") {
    $sql = "SELECT MAX(bank_invoice_id)+1 AS invoice_id FROM invoice_bank WHERE bank_invoice_year='".date("Y")."' ";
    $rs = Db::query($sql);
    $row = $rs[0]??[];
    if (empty($row['invoice_id'])) {
        $invoice_id = 1;
    } else {
        $invoice_id = $row['invoice_id'];
    }
    $invoice[1] = sprintf("%05d",$member_id).substr(date("Y"),2,4).sprintf("%05d",$invoice_id);
    $invoice[0] = $invoice_id;
    return $invoice;
}

/**
 * 获取当前支付配置
 * @return mixed
 */
function get_current_payment()
{
    $current_payment = \config('current_payment');
    $current_payment_type = \config('current_payment_type');
    return \config($current_payment . '.' . $current_payment_type);
}

/**
 * @param $objectId
 * @return bool
 * @throws DataNotFoundException
 * @throws ModelNotFoundException
 * @throws DbException
 */
function alipay_inquiry_transaction($objectId)
{
    $send2bank = Send2bank::where('charge_id',$objectId)->find();
    if (empty($send2bank)){
        return false;
    }
    if ($send2bank['responce_time'] != 0){
        return false;
    }
    $inquiry_charge_id = !empty($send2bank['charge_id'])?$send2bank['charge_id']:$send2bank['send_invoice'];
    $payment_config = get_current_payment();
    $url = $payment_config['payment_api_sdomain'] . "/card/v2/charge/{$inquiry_charge_id}";
    $HTTPHEADER = [
        'Content-Type: application/json; charset=utf-8',
        'x-api-key: ' . $payment_config['payment_api_skey']
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $HTTPHEADER);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);
    curl_close($ch);

    $arr_data = json_decode($response, true);
    if(isset($arr_data['status'])) {
        $response_data = [];
        $response_data['response_data'] = $response;
        $response_data['responsed_at'] = date('Y-m-d H:i:s');
        $response_data['http_referer'] = '';
        $response_data['bank_checksum'] = null;
        $response_data['local_checksum'] = null;
        $response_data['remark'] = 'Inquiry Transaction';
        Test::create($response_data);
        $response_data = [];
        $payment_status = $arr_data['status'];
        $invoice = $arr_data['reference_order'];
        $resp_code = ($payment_status == 'success' && in_array($arr_data['transaction_state'], ['Authorized', 'Settled'])) ? '00' : '66';

        $response_data['resp_code'] = $resp_code;
        $response_data['payment_status'] = $payment_status;
        $response_data['reference'] = $arr_data['id'];
        $response_data['authorize'] = $arr_data['approval_code'];
        $response_data['uaid'] = $arr_data['transaction_state'];
        $response_data['invoice'] = $invoice;
        $response_data['timestamp'] = $arr_data['created'];
        $response_data['amount'] = $arr_data['amount'];
        $response_data['checksum'] = null;
        $response_data['cardtype'] = $arr_data['source']['brand'];
        $response_data['checksumcard2'] = $arr_data['source']['card_masking'];
        $response_data['PMGWRESP'] = $response;
        $response_data['http_referer'] = '';
        $response_data['all_post_return'] = '';
        $response_data['all_get_return'] = '';
        $response_data['remark'] = 'Inquiry Transaction: ' . $inquiry_charge_id;
        $response_data['response_datetime'] = date('Y-m-d H:i:s');
        \app\admin\model\invoice\Response::create($response_data);

        return payment_response_record($resp_code, $invoice);
    }
    return true;
}

/**
 * @param $resp_code
 * @param $invoice
 * @return bool
 * @throws \think\Exception
 * @throws DataNotFoundException
 * @throws ModelNotFoundException
 * @throws DbException
 */
function payment_response_record($resp_code, $invoice)
{
    $send2bank = new Send2bank();
    $send2bank->where('send_invoice',$invoice)->setInc('responce_time');
    $send2bank->where('send_invoice',$invoice)->update([
        'responce_last' => date('Y-m-d H:i:s')
    ]);

    $invoice_bank_transaction = new Transaction();
    $invoice_bank_transaction->where('bank_invoice_no',$invoice)->setInc('bank_responce');
    $invoice_bank_transaction->where('bank_invoice_no',$invoice)->update([
        'responce_time' => date('Y-m-d H:i:s'),
        'responce_code' => $resp_code
    ]);
    $membership_detail = new Detail();
    if ($resp_code == "00") {
        $invoice_bank_transactions = $invoice_bank_transaction->where('bank_invoice_no', $invoice)->select();
        if (!empty($invoice_bank_transactions)) {
            foreach ($invoice_bank_transactions as $invoice_bank_transaction) {
                $uaid = \app\admin\model\invoice\Response::where('invoice',$invoice_bank_transaction['bank_invoice_no'])->value('uaid');
                if (empty($uaid) || $uaid !== 'Authorized'){
                    continue;
                }
                $updData = [];
                $updData['paid_amount'] = $invoice_bank_transaction['paid_amount'];
                $updData['paid_status'] = 'Y';
                $updData['ms_detail_paid'] = 'P';
                $updData['ms_detail_paid_date'] =  date('Y-m-d H:i:s');
                $updData['paid_method'] = '1';
                $updData['bank_invoice_no'] = $invoice_bank_transaction['bank_invoice_no'];
                $membership_detail->where('ms_detail_id', $invoice_bank_transaction['ms_detail_id'])->update($updData);
            }
        } else {
            $count_membership_details = $membership_detail->where('bank_invoice_no', $invoice)->count();
            if ($count_membership_details > 0) {
                $updData = [];
                $updData['paid_status'] = 'Y';
                $updData['ms_detail_paid'] = 'P';
                $updData['ms_detail_paid_date'] = date('Y-m-d H:i:s');
                $updData['paid_method'] = '1';
                $membership_detail->where('bank_invoice_no', $invoice)->update($updData);
            }
        }

        $payment_record = new Record();
        $payment_record->where('invoice_bank', $invoice)->update( ['paid_status' => 'Y']);

        $orders = new Orders();
        $orders_id = $orders->where('bank_invoice_no', $invoice)->value('orders_id');
        if ($orders_id) {
            $orders->where('bank_invoice_no', $invoice)->update([
                'status_paid' => 'P',
                'status_new' => 'E',
                'paid_completed' => 'Y',
                'paid_date' => date('Y-m-d H:i:s'),
                'paid_method_str' => '1',
                'paid_method_id' => '1'
            ]);

            Db::execute("UPDATE orders_addi SET status_paid='P' , addi_paid='Y', addi_paid_amount=grand_total WHERE orders_id = ?", [$orders_id]);

            Db::execute("UPDATE orders_bonus SET status_paid='P' , bonus_paid='Y', bonus_paid_amount=grand_total WHERE orders_id = ?", [$orders_id]);

            Db::execute("UPDATE orders_extra SET status_paid='P' , extra_paid='Y', extra_paid_amount=grand_total WHERE orders_id = ?", [$orders_id]);

            Db::execute("UPDATE orders_van SET status_paid='P' , van_paid='Y', van_paid_amount=grand_total WHERE orders_id = ?", [$orders_id]);
        }
        return true;
    }
    return false;
}

function local_checksum($arr_data)
{
    $payment_config = get_current_payment();
    $amount = number_format($arr_data['amount'], 4, '.', '');
    $localChecksumText = $arr_data['id'] . $amount . $arr_data['currency'] . $arr_data['status'] . $arr_data['transaction_state'] . $payment_config['payment_api_skey'];
    return hash('sha256', $localChecksumText);
}

function compare_checksum($arr_data)
{
    if (isset($arr_data['checksum']) && $arr_data['checksum'] == local_checksum($arr_data)) {
        return true;
    } else {
        return false;
    }
}

function qr_inquiry_transaction ($charge_id, $count_resp, $sleep=true) {
    if($count_resp == 0) {
        if($sleep) {
            $sleep_seconds = (8 * 60);
            sleep($sleep_seconds);
        }
        $payment_config = get_current_payment();
        $url = $payment_config['payment_api_sdomain'] . "/qr/v2/qr/{$charge_id}";
        $HTTPHEADER = [
            'Content-Type: application/json; charset=utf-8',
            'x-api-key: ' . $payment_config['payment_api_skey']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $HTTPHEADER);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        curl_close($ch);

        $arr_data = json_decode($response, true);

        if(isset($arr_data['status'])) {
            $response_data = [];
            $response_data['response_data'] = $response;
            $response_data['responsed_at'] = date('Y-m-d H:i:s');
            $response_data['http_referer'] = '';
            $response_data['bank_checksum'] = null;
            $response_data['local_checksum'] = null;
            $response_data['remark'] = 'Inquiry Transaction';
            Test::create($response_data);
            $response_data = [];
            $payment_status = $arr_data['status'];
            $invoice = $arr_data['reference_order'];
            $resp_code = ($payment_status == 'success' && in_array($arr_data['transaction_state'], ['Authorized', 'Settled'])) ? '00' : '66';

            $response_data['resp_code'] = $resp_code;
            $response_data['payment_status'] = $payment_status;
            $response_data['reference'] = $arr_data['id'];
            $response_data['authorize'] = $arr_data['approval_code']??'';
            $response_data['uaid'] = $arr_data['order_id'];
            $response_data['invoice'] = $invoice;
            $response_data['timestamp'] = $arr_data['created'];
            $response_data['amount'] = $arr_data['amount'];
            $response_data['checksum'] = null;
            $response_data['cardtype'] = $arr_data['source']['brand'];
            $response_data['checksumcard2'] = $arr_data['source']['id'];
            $response_data['PMGWRESP'] = $response;
            $response_data['http_referer'] = '';
            $response_data['all_post_return'] = '';
            $response_data['all_get_return'] = '';
            $response_data['remark'] = 'Inquiry Transaction: ' . $charge_id;
            $response_data['response_datetime'] = date('Y-m-d H:i:s');
            \app\admin\model\invoice\Response::create($response_data);

            payment_response_record($resp_code, $invoice);
        }
        if(!$sleep) {
            return $arr_data;
        }
    }
    return [];
}


function api_inquiry_transaction ($charge_id, $count_resp = 0, $sleep_seconds=null) {

    if($count_resp == 0) {
        if (!empty($sleep_seconds)){
            sleep($sleep_seconds);
        }
        $payment_config = get_current_payment();
        $url = $payment_config['payment_api_sdomain'] . "/card/v2/charge/{$charge_id}";
        $HTTPHEADER = [
            'Content-Type: application/json; charset=utf-8',
            'x-api-key: ' . $payment_config['payment_api_skey']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $HTTPHEADER);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        curl_close($ch);

        $arr_data = json_decode($response, true);

        if(isset($arr_data['status'])) {
            $response_data = [];
            $response_data['response_data'] = $response;
            $response_data['responsed_at'] = date('Y-m-d H:i:s');
            $response_data['http_referer'] = '';
            $response_data['bank_checksum'] = null;
            $response_data['local_checksum'] = null;
            $response_data['remark'] = 'Inquiry Transaction';
            Test::create($response_data);
            $response_data = [];
            $payment_status = $arr_data['status'];
            $invoice = $arr_data['reference_order'];
            $resp_code = ($payment_status == 'success' && in_array($arr_data['transaction_state'], ['Authorized', 'Settled'])) ? '00' : '66';

            $response_data['resp_code'] = $resp_code;
            $response_data['payment_status'] = $payment_status;
            $response_data['reference'] = $arr_data['id'];
            $response_data['authorize'] = $arr_data['approval_code'];
            $response_data['uaid'] = $arr_data['transaction_state'];
            $response_data['invoice'] = $invoice;
            $response_data['timestamp'] = $arr_data['created'];
            $response_data['amount'] = $arr_data['amount'];
            $response_data['checksum'] = null;
            $response_data['cardtype'] = $arr_data['source']['brand'];
            $response_data['checksumcard2'] = $arr_data['source']['card_masking'];
            $response_data['PMGWRESP'] = $response;
            $response_data['http_referer'] = '';
            $response_data['all_post_return'] = '';
            $response_data['all_get_return'] = '';
            $response_data['remark'] = 'Inquiry Transaction: ' . $charge_id;
            $response_data['response_datetime'] = date('Y-m-d H:i:s');
            \app\admin\model\invoice\Response::create($response_data);
            return payment_response_record($resp_code, $invoice);
        }
    }
    return true;
}