<?php

namespace app\index\controller;

use addons\wechat\model\WechatCaptcha;
use app\admin\model\Booking;
use app\admin\model\Country;
use app\admin\model\Hierarchy;
use app\admin\model\invoice\Bank;
use app\admin\model\invoice\bank\Order;
use app\admin\model\invoice\bank\Transaction;
use app\admin\model\invoice\History;
use app\admin\model\invoice\Response;
use app\admin\model\Language;
use app\admin\model\Marketer;
use app\admin\model\Member;
use app\admin\model\membership\Detail;
use app\admin\model\News;
use app\admin\model\Orders;
use app\admin\model\orders\Addi;
use app\admin\model\orders\Bonus;
use app\admin\model\orders\Extra;
use app\admin\model\orders\Van;
use app\admin\model\paid\Method;
use app\admin\model\payment\Record;
use app\admin\model\Send2bank;
use app\common\controller\Frontend;
use app\common\library\Ems;
use app\common\library\Sms;
use app\common\model\Attachment;
use fast\Encrypt;
use fast\Random;
use think\Collection;
use think\Config;
use think\Cookie;
use think\Db;
use think\db\exception\DataNotFoundException;
use think\db\exception\ModelNotFoundException;
use think\Exception;
use think\exception\DbException;
use think\Hook;
use think\Validate;

/**
 * 会员中心
 */
class User extends Frontend
{
    protected $layout = 'default';
    protected $noNeedLogin = ['login', 'register', 'third', 'change_database'];
    protected $noNeedRight = ['*'];

    public function _initialize()
    {
        parent::_initialize();
        $auth = $this->auth;
        if (!Config::get('fastadmin.usercenter')) {
            $this->error(__('User center already closed'), '/');
        }

        //监听注册登录退出的事件
        Hook::add('user_login_successed', function ($user) use ($auth) {
            $expire = input('post.keeplogin') ? 30 * 86400 : 0;
            Cookie::set('uid', $user->id, $expire);
            Cookie::set('token', $auth->getToken(), $expire);
        });
        Hook::add('user_register_successed', function ($user) use ($auth) {
            Cookie::set('uid', $user->id);
            Cookie::set('token', $auth->getToken());
        });
        Hook::add('user_delete_successed', function ($user) use ($auth) {
            Cookie::delete('uid');
            Cookie::delete('token');
        });
        Hook::add('user_logout_successed', function ($user) use ($auth) {
            Cookie::delete('uid');
            Cookie::delete('token');
        });
        $this->view->assign('is_thb_system',(bool)\think\Session::get('user_thb_system'));
    }

    /**
     * 会员中心
     */
    public function index()
    {
        $this->view->assign('title', __('User center'));

        // 查最新新闻
        $news = new News();
        $news_list = $news->order('id','desc')->limit(10)->select();
        $this->view->assign('news_list',$news_list);

        return $this->view->fetch();
    }

    /**
     * 注册会员
     */
    public function register()
    {
        $url = $this->request->request('url', '', 'url_clean');
        if ($this->auth->id) {
            $this->success(__('You\'ve logged in, do not login again'), $url ? $url : url('user/index'));
        }
        if ($this->request->isPost()) {
            $username = $this->request->post('username');
            $password = $this->request->post('password', '', null);
            $email = $this->request->post('email');
            $mobile = $this->request->post('mobile', '');
            $captcha = $this->request->post('captcha');
            $token = $this->request->post('__token__');
            $rule = [
                'username' => 'require|length:3,30',
                'password' => 'require|length:6,30',
                'email' => 'require|email',
                'mobile' => 'regex:/^1\d{10}$/',
                '__token__' => 'require|token',
            ];

            $msg = [
                'username.require' => 'Username can not be empty',
                'username.length' => 'Username must be 3 to 30 characters',
                'password.require' => 'Password can not be empty',
                'password.length' => 'Password must be 6 to 30 characters',
                'email' => 'Email is incorrect',
                'mobile' => 'Mobile is incorrect',
            ];
            $data = [
                'username' => $username,
                'password' => $password,
                'email' => $email,
                'mobile' => $mobile,
                '__token__' => $token,
            ];
            //验证码
            $captchaResult = true;
            $captchaType = config("fastadmin.user_register_captcha");
            if ($captchaType) {
                if ($captchaType == 'mobile') {
                    $captchaResult = Sms::check($mobile, $captcha, 'register');
                } elseif ($captchaType == 'email') {
                    $captchaResult = Ems::check($email, $captcha, 'register');
                } elseif ($captchaType == 'wechat') {
                    $captchaResult = WechatCaptcha::check($captcha, 'register');
                } elseif ($captchaType == 'text') {
                    $captchaResult = \think\Validate::is($captcha, 'captcha');
                }
            }
            if (!$captchaResult) {
                $this->error(__('Captcha is incorrect'));
            }
            $validate = new Validate($rule, $msg);
            $result = $validate->check($data);
            if (!$result) {
                $this->error(__($validate->getError()), null, ['token' => $this->request->token()]);
            }
            if ($this->auth->register($username, $password, $email, $mobile)) {
                $this->success(__('Sign up successful'), $url ? $url : url('user/index'));
            } else {
                $this->error($this->auth->getError(), null, ['token' => $this->request->token()]);
            }
        }
        //判断来源
        $referer = $this->request->server('HTTP_REFERER', '', 'url_clean');
        if (!$url && $referer && !preg_match("/(user\/login|user\/register|user\/logout)/i", $referer)) {
            $url = $referer;
        }
        $this->view->assign('captchaType', config('fastadmin.user_register_captcha'));
        $this->view->assign('url', $url);
        $this->view->assign('title', __('Register'));
        return $this->view->fetch();
    }

    public function change_database()
    {
        $check = input('check');
        if (!empty($check)) {
            session('user_thb_system', true);
        } else {
            session('user_thb_system', null);
        }
        return json();
    }

    /**
     * 会员登录
     */
    public function login()
    {
        $url = $this->request->request('url', '', 'url_clean');
        if ($this->auth->id) {
            $this->success(__('You\'ve logged in, do not login again'), $url ?: url('user/index'));
        }
        if ($this->request->isPost()) {
            $account = $this->request->post('account');
            $password = $this->request->post('password', '', null);
            $keeplogin = (int)$this->request->post('keeplogin');
            if ($keeplogin == 1) {
                session('user_thb_system', true);
            } else {
                session('user_thb_system', null);
            }
            $token = $this->request->post('__token__');
            $rule = [
                'account' => 'require|length:3,50',
                'password' => 'require|length:1,30',
//                '__token__' => 'require|token',
            ];

            $msg = [
                'account.require' => 'Account can not be empty',
                'account.length' => 'Account must be 1 to 50 characters',
                'password.require' => 'Password can not be empty',
                'password.length' => 'Password must be 6 to 30 characters',
            ];
            $data = [
                'account' => $account,
                'password' => $password,
//                '__token__' => $token,
            ];
            $validate = new Validate($rule, $msg);
            $result = $validate->check($data);
            if (!$result) {
                $this->error(__($validate->getError()), null, ['token' => $this->request->token()]);
            }
            // 转存用户数据信息
            $member_data = Member::where('username', $account)
                ->where('hidden', 0)
                ->find();
            if (empty($member_data)) {
                $this->error(__('Account is incorrect'));
            }
            $member_password = $member_data['passwords'];
            $encrypt = new Encrypt();
            $mpass = $encrypt->decode($member_password);
            if (empty($mpass)) {
                $mpass = crypt_md5($member_password);
            }
            $salt = Random::alnum();
            $createtime = strtotime($member_data['createdate']);
            if (empty($createtime)) {
                $createtime = time();
            }
            $user_data = [
                'group_id' => 1,
                'username' => $member_data['username'],
                'nickname' => $member_data['login_name'] . ' ' . $member_data['login_surname'],
                'password' => md5(md5($mpass) . $salt),
                'salt' => $salt,
                'email' => $member_data['email'],
                'mobile' => !empty($member_data['mobile']) ? substr($member_data['mobile'], 0, 11) : '',
                'birthday' => $member_data['birthday'],
                'prevtime' => time(),
                'logintime' => time(),
                'jointime' => $createtime,
                'createtime' => $createtime,
                'updatetime' => time(),
                'loginip' => request()->ip(),
                'joinip' => request()->ip(),
                'status' => 'normal',
                'avatar' => '/assets/img/avatar.png',
                'memberid' => $member_data['memberid'],
            ];
            $num = \app\common\model\User::where('memberid', $member_data['memberid'])->count();
            if ($num > 0) {
                // 更新
                unset($user_data['createtime']);
                unset($user_data['jointime']);
                unset($user_data['joinip']);
                unset($user_data['logintime']);
                unset($user_data['prevtime']);
                unset($user_data['avatar']);
                \app\common\model\User::where('memberid', $member_data['memberid'])->update($user_data);
            } else {
                // 添加
                \app\common\model\User::create($user_data);
            }
            if ($this->auth->login($account, $password)) {
                $this->success(__('Logged in successful'), $url ? $url : url('user/index'));
            } else {
                $this->error($this->auth->getError(), null, ['token' => $this->request->token()]);
            }
        }
        //判断来源
        $referer = $this->request->server('HTTP_REFERER', '', 'url_clean');
        if (!$url && $referer && !preg_match("/(user\/login|user\/register|user\/logout)/i", $referer)) {
            $url = $referer;
        }
        $this->view->assign('url', $url);
        $this->view->assign('title', __('Login'));
        return $this->view->fetch();
    }

    /**
     * 退出登录
     */
    public function logout()
    {
        if ($this->request->isPost()) {
            $this->token();
            //退出本站
            $this->auth->logout();
            session('user_thb_system', null);
            $this->success(__('Logout successful'), url('user/index'));
        }
        $html = "<form id='logout_submit' name='logout_submit' action='' method='post'>" . token() . "<input type='submit' value='ok' style='display:none;'></form>";
        $html .= "<script>document.forms['logout_submit'].submit();</script>";

        return $html;
    }

    /**
     * 个人信息
     */
    public function profile()
    {
        $this->view->assign('title', __('General Details'));
        $member = new Member();
        $this->view->assign("titleList", $member->getTitleList());
        return $this->view->fetch();
    }

    public function marketer()
    {
        $size = input('pageSize', 10);
        $page = input('pageNumber', 1);
        $q_word = input('q_word/a');
        $map = [];
        if (!empty($q_word[0])) {
            $map['login_name'] = ['like', '%' . $q_word[0] . '%'];
        }
        $searchValue = input('searchValue');
        if (!empty($searchValue)) {
            $map['marketerid'] = $searchValue;
        }
        $list = Marketer::field('login_name,marketerid')
            ->where($map)
            ->where('hidden', 0)
            ->paginate($size, false, [
                'page' => $page
            ]);
        return json([
            'list' => $list->items(),
            'total' => $list->total()
        ]);
    }

    public function country()
    {
        $size = input('pageSize', 10);
        $page = input('pageNumber', 1);
        $q_word = input('q_word/a');
        $map = [];
        if (!empty($q_word[0])) {
            $map['country_name'] = ['like', '%' . $q_word[0] . '%'];
        }
        $searchValue = input('searchValue');
        if (!empty($searchValue)) {
            $map['countryid'] = $searchValue;
        }
        $list = Country::field('country_name,countryid')
            ->where($map)
            ->paginate($size, false, [
                'page' => $page
            ]);
        return json([
            'list' => $list->items(),
            'total' => $list->total()
        ]);
    }

    public function language()
    {
        $size = input('pageSize', 10);
        $page = input('pageNumber', 1);
        $q_word = input('q_word/a');
        $map = [];
        if (!empty($q_word[0])) {
            $map['language_name'] = ['like', '%' . $q_word[0] . '%'];
        }
        $searchValue = input('searchValue');
        if (!empty($searchValue)) {
            $map['languageid'] = $searchValue;
        }
        $list = Language::field('language_name,languageid')
            ->where($map)
            ->paginate($size, false, [
                'page' => $page
            ]);
        return json([
            'list' => $list->items(),
            'total' => $list->total()
        ]);

    }

    /**
     * 修改密码
     */
    public function changepwd()
    {
        if ($this->request->isPost()) {
            $oldpassword = $this->request->post("oldpassword", '', null);
            $newpassword = $this->request->post("newpassword", '', null);
            $renewpassword = $this->request->post("renewpassword", '', null);
            $token = $this->request->post('__token__');
            $rule = [
//                'oldpassword' => 'require|regex:\S{1,30}',
                'newpassword' => 'require|regex:\S{6,30}',
                'renewpassword' => 'require|regex:\S{6,30}|confirm:newpassword',
                '__token__' => 'token',
            ];

            $msg = [
                'renewpassword.confirm' => __('Password and confirm password don\'t match')
            ];
            $data = [
                'oldpassword' => $oldpassword,
                'newpassword' => $newpassword,
                'renewpassword' => $renewpassword,
                '__token__' => $token,
            ];
            $field = [
                'oldpassword' => __('Old password'),
                'newpassword' => __('New password'),
                'renewpassword' => __('Renew password')
            ];
            $validate = new Validate($rule, $msg, $field);
            $result = $validate->check($data);
            if (!$result) {
                $this->error(__($validate->getError()), null, ['token' => $this->request->token()]);
            }

            $ret = $this->auth->changepwd($newpassword, $oldpassword,true);
            $encrypt = new Encrypt();
            $member_password = $encrypt->encode($newpassword);
            $user = $this->auth->getUser();
            Member::where('memberid', $user->member->memberid)->update([
                'passwords' => $member_password,
                'updateby_member' => 1
            ]);
            if ($ret) {
                $this->success(__('Reset password successful'), url('user/login'));
            } else {
                $this->error($this->auth->getError(), null, ['token' => $this->request->token()]);
            }
        }
        $this->view->assign('title', __('Change password'));
        return $this->view->fetch();
    }

    public function attachment()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags']);
        if ($this->request->isAjax()) {
            $mimetypeQuery = [];
            $where = [];
            $filter = $this->request->request('filter');
            $filterArr = (array)json_decode($filter, true);
            if (isset($filterArr['mimetype']) && preg_match("/(\/|\,|\*)/", $filterArr['mimetype'])) {
                $this->request->get(['filter' => json_encode(array_diff_key($filterArr, ['mimetype' => '']))]);
                $mimetypeQuery = function ($query) use ($filterArr) {
                    $mimetypeArr = array_filter(explode(',', $filterArr['mimetype']));
                    foreach ($mimetypeArr as $index => $item) {
                        $query->whereOr('mimetype', 'like', '%' . str_replace("/*", "/", $item) . '%');
                    }
                };
            } elseif (isset($filterArr['mimetype'])) {
                $where['mimetype'] = ['like', '%' . $filterArr['mimetype'] . '%'];
            }

            if (isset($filterArr['filename'])) {
                $where['filename'] = ['like', '%' . $filterArr['filename'] . '%'];
            }

            if (isset($filterArr['createtime'])) {
                $timeArr = explode(' - ', $filterArr['createtime']);
                $where['createtime'] = ['between', [strtotime($timeArr[0]), strtotime($timeArr[1])]];
            }
            $search = $this->request->get('search');
            if ($search) {
                $where['filename'] = ['like', '%' . $search . '%'];
            }

            $model = new Attachment();
            $offset = $this->request->get("offset", 0);
            $limit = $this->request->get("limit", 0);
            $total = $model
                ->where($where)
                ->where($mimetypeQuery)
                ->where('user_id', $this->auth->id)
                ->order("id", "DESC")
                ->count();

            $list = $model
                ->where($where)
                ->where($mimetypeQuery)
                ->where('user_id', $this->auth->id)
                ->order("id", "DESC")
                ->limit($offset, $limit)
                ->select();
            $cdnurl = preg_replace("/\/(\w+)\.php$/i", '', $this->request->root());
            foreach ($list as $k => &$v) {
                $v['fullurl'] = ($v['storage'] == 'local' ? $cdnurl : $this->view->config['upload']['cdnurl']) . $v['url'];
            }
            unset($v);
            $result = array("total" => $total, "rows" => $list);

            return json($result);
        }
        $mimetype = $this->request->get('mimetype', '');
        $mimetype = substr($mimetype, -1) === '/' ? $mimetype . '*' : $mimetype;
        $this->view->assign('mimetype', $mimetype);
        $this->view->assign("mimetypeList", \app\common\model\Attachment::getMimetypeList());
        return $this->view->fetch();
    }

    public function my_booking()
    {
        $booking = new Booking();
        $user = $this->auth->getUser();
        $booking_list = $booking->where('memberid', $user->member->memberid)->select();
        $this->view->assign('booking_list', $booking_list);

        $this->view->assign('title', __('My Booking'));
        return $this->view->fetch();
    }

    public function my_order()
    {
        $orders = new Orders();
        $user = $this->auth->getUser();
        $orders_list = $orders->where('memberid', $user->member->memberid)->select();
        if (!empty($orders_list)) {
            $orders_addi = new Addi();
            $orders_bonus = new Bonus();
            $orders_extra = new Extra();
            $orders_van = new Van();
            $paid_method = new Method();
            foreach ($orders_list as &$v) {
                $sum_grandtotal = 0;
                $sum_paid_amount = 0;
                $num_total_service = 0;
                $result = $orders_addi->fieldRaw('COUNT(orders_addi_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(addi_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_bonus->fieldRaw('COUNT(orders_bonus_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(bonus_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_extra->fieldRaw('COUNT(orders_extra_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(extra_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_van->fieldRaw('COUNT(orders_van_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(van_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $v->num_total_service = $num_total_service;
                $v->sum_grandtotal = $sum_grandtotal;
                $v->sum_paid_amount = $sum_paid_amount;

                if (!empty($v->paid_method_str)) {
                    $tmp = $paid_method->whereIn('paid_method_id', $v->paid_method_str)->select();
                    if (!empty($tmp)) {
                        $v->paid_method_names = implode(',', array_column($tmp, 'paid_method_name'));
                    } else {
                        $v->paid_method_names = '-';
                    }
                } else {
                    $v->paid_method_names = '-';
                }
            }
        }
        $this->view->assign('orders_list', $orders_list);
        $this->view->assign('title', __('My Order'));
        return $this->view->fetch();
    }

    public function my_membership()
    {
        $hierarchy = new Hierarchy();
        $user = $this->auth->getUser();
        $hierarchy_list = $hierarchy->where('hierarchy.memberid', $user->member->memberid)
            ->with([
                'package' => function ($query) {
                    $query->withField('packagename');
                },
                'partner' => function ($query) {
                    $query->withField('login_name');
                }
            ])
            ->orderRaw("FIELD(hierarchy.contract_status, '', 'use', 'stop')")
            ->select();
        if (!empty($hierarchy_list)) {
            $membership_detail = new Detail();
            foreach ($hierarchy_list as &$item) {
                $membership_detail_list = $membership_detail->alias('MBSD')
                    ->fieldRaw("MBSD.ms_detail_id AS  MSB_Detail_ID
		,  PK.packagename	 AS	MSB_Detail_Type
		,  MBSD.total_week AS    Week_per_Year
		,  MBSD.ms_detail_year AS	MSB_Detail_Year
		,  MBSD.ms_detail_paid	AS	MSB_Detail_Paid
		,  MBSD.ms_detail_used AS	MSB_Detail_Used
		,  MBSD.ms_detail_paid_date	AS	MSB_Detail_Paid_Date
		,  MBSD.paid_amount  AS	MSB_Detail_Paid_Amount
		,  PM.paid_method_name AS	MSB_Detail_Paid_Method
		,  MBSD.paid_status AS	MSB_Detail_Paid_Status
		,  MBSD.ms_detail_remark	    	AS	MSB_Detail_Paid_Remark
		,  MBSD.used_fullweek		  		AS	MSB_Detail_UsedFW
		,  MBSD.used_midweek		  		AS	MSB_Detail_UsedMW
		,  MBSD.used_weekend		  		AS	MSB_Detail_UsedWE
		/*
		,  MBSD.special_amount		  		AS	Maintenance_Fee_Special
		,  PKS.packageprice_prices	  		AS	Maintenance_Fee
		*/
		,  booking.booking_id					AS	Booking_ID
		,  BKD.booking_detail_fullweek		AS	Booking_Full_Week
		,  BKD.booking_detail_midweek	AS	Booking_Mid_Week
		,  BKD.booking_detail_weekend	AS	Booking_Weekend

		,  PRC.paid_method AS paid_method 
		,  PRC.paid_amount AS paid_amount
		,  PRC.servicetype AS servicetype
		,  PRC.packageid AS package_id
		,  PRC.packagename  AS package_name
		,  PRC.packagepriceid
		,  PRC.packageprice_years
		,  PRC.packageprice_prices AS package_price
		, CASE MBSD.paid_status
			WHEN 'N' THEN PKS.packageprice_prices	
			WHEN 'Y' AND PRC.packageprice_prices THEN PRC.packageprice_prices
			ELSE PKS.packageprice_prices
		END AS Maintenance_Fee
		, IF(PRC.special_prices, PRC.special_prices, MBSD.special_amount) AS Maintenance_Fee_Special")
                    ->join('payment_record PRC', "PRC.ms_detail_id = MBSD.ms_detail_id AND PRC.paid_status = 'Y'", 'left')
                    ->join('package PK', "PK.packageid = MBSD.packageid", 'left')
                    ->join('paid_method PM', "PM.paid_method_id = MBSD.paid_method", 'left')
                    ->join('packageprice PKS', "PKS.packageid = MBSD.packageid AND PKS.packageprice_years  = MBSD.ms_detail_year", 'left')
                    ->join('booking', "booking.hierarchyid = MBSD.hierarchyid", 'left')
                    ->join('booking_detail BKD', "BKD.booking_id=booking.booking_id", 'left')
                    ->where('MBSD.hierarchyid', $item->hierarchyid)
                    ->where('MBSD.ms_detail_year', '>=', date('Y') - 2)
                    ->order('MBSD.ms_detail_year', 'asc')
                    ->select();
                $tmp = [];
                foreach ($membership_detail_list as $v2) {
                    $v2_arr = $v2->toArray();
                    $v2_arr['Available'] = availableTime($v2_arr);
                    $tmp[] = $v2_arr;
                }
                $item->membership_detail_list = $tmp;
            }
        }
        $this->view->assign('hierarchy_list', $hierarchy_list);
        $this->view->assign('title', __('My Membership'));
        return $this->view->fetch();
    }

    public function billing()
    {
        $user = $this->auth->getUser();
        $memberid = $user->member->memberid;
        $this->init_unpaidhierarchy($memberid);
        $this->init_unpaidorder($memberid);
        $this->init_paidorder($memberid);
        $this->init_paidhierarchy($memberid);
        $this->view->assign('title', __('Billing Details'));
        return $this->view->fetch();
    }

    /**
     * @param $ids
     * @return void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    public function init_unpaidorder($ids)
    {
        $orders = new \app\admin\model\Orders();
        $orders_list = $orders->where('memberid', $ids)
            ->where('paid_completed', 'N')
            ->whereRaw("status_new='N' OR status_new='E'")
            ->select();
        if (!empty($orders_list)) {
            $orders_addi = new Addi();
            $orders_bonus = new Bonus();
            $orders_extra = new Extra();
            $orders_van = new Van();
            $paid_method = new Method();
            foreach ($orders_list as &$v) {
                $sum_grandtotal = 0;
                $sum_paid_amount = 0;
                $num_total_service = 0;
                $result = $orders_addi->fieldRaw('COUNT(orders_addi_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(addi_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_bonus->fieldRaw('COUNT(orders_bonus_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(bonus_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_extra->fieldRaw('COUNT(orders_extra_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(extra_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_van->fieldRaw('COUNT(orders_van_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(van_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $v->num_total_service = $num_total_service;
                $v->sum_grandtotal = $sum_grandtotal;
                $v->sum_paid_amount = $sum_paid_amount;

                if (!empty($v->paid_method_str)) {
                    $tmp = $paid_method->whereIn('paid_method_id', $v->paid_method_str)->select();
                    if (!empty($tmp)) {
                        $v->paid_method_names = implode(',', array_column($tmp, 'paid_method_name'));
                    } else {
                        $v->paid_method_names = '-';
                    }
                } else {
                    $v->paid_method_names = '-';
                }
            }
        }
        $this->view->assign('orders_list', $orders_list);
    }

    /**
     * 初始化Membership
     * @param $ids
     * @return bool|\PDOStatement|string|\think\Collection
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    private function init_unpaidhierarchy($ids)
    {
        $hierarchy = new Hierarchy();
        $hierarchy_list = $hierarchy->where('hierarchy.memberid', $ids)
            ->where('hierarchy.contract_status', '<>', 'stop')
            ->with([
                'package' => function ($query) {
                    $query->withField('packagename');
                },
                'partner' => function ($query) {
                    $query->withField('login_name');
                }
            ])
            ->select();
        $has_child_data = false;
        if (!empty($hierarchy_list)) {
            $history = new History();
            foreach ($hierarchy_list as &$item) {
                $membership_detail_list = $hierarchy->alias('H')
                    ->fieldRaw("MBSD.ms_detail_id AS   ms_detail_id
					,  MBSD.total_week AS  week_per_year
					,  MBSD.ms_detail_year AS entitlement_year
					,  MBSD.special_amount
					,  MBSD.ms_detail_paid AS ms_detail_paid
					,  MBSD.ms_detail_used AS ms_detail_used
					,  MBSD.hierarchyid AS membership_id
					,  H.hierarchyid
					,  H.remarks
					,  H.servicetype AS servicetype
					,  H.contract_no AS contract_no
					,  DATE_FORMAT(MBSD.ms_detail_paid_date,'%d/%m/%Y') AS 	paid_date
					,  DATE_FORMAT(MBSD.ms_detail_paid_date,'%H:%i') AS paid_time
					,  MBSD.paid_method AS paid_method
					,  MBSD.paid_amount AS paid_amount
					,  MBSD.paid_status AS paid_status
					,  MBSD.paid_remark AS paid_remark
					,  PK.packagename  AS package_name
					,  PK.packageid AS package_id

					,  PKP.packageprice_prices AS package_price

					,  PKP.packageprice_amount1 AS amount1
					,  PKP.packageprice_prices1 AS price1
					,  PKP.packageprice_amount2 AS amount2
					,  PKP.packageprice_prices2 AS price2
					,  PKP.packageprice_amount3 AS amount3
					,  PKP.packageprice_prices3 AS price3
					,  PKP.packageprice_amount4 AS amount4
					,  PKP.packageprice_prices4 AS price4
					,  PKP.packageprice_amount5 AS amount5
					,  PKP.packageprice_prices5 AS price5")
                    ->join('membership_detail MBSD', "MBSD.hierarchyid = H.hierarchyid", 'left')
                    ->join('package PK', "PK.packageid = MBSD.packageid", 'left')
                    ->join('packageprice PKP', "PKP.packageid = MBSD.packageid  AND PKP.packageprice_years = MBSD.ms_detail_year")
                    ->where('MBSD.hierarchyid', $item->hierarchyid)
                    ->whereRaw("MBSD.paid_status = 'N' OR MBSD.paid_status='' OR ISNULL(MBSD.paid_status)")
                    ->whereRaw("MBSD.ms_detail_paid = 'W' OR MBSD.ms_detail_paid = 'N' OR MBSD.ms_detail_paid='P'")
                    ->order('MBSD.ms_detail_year', 'asc')
                    ->select();
                $tmp = [];
                foreach ($membership_detail_list as $v2) {
                    $v2_arr = $v2->toArray();
                    $history_tmp = $history->where('hierarchyid', $v2_arr['membership_id'])
                        ->where('member_id', $ids)
                        ->where('entitlement_year', $v2_arr['entitlement_year'])
                        ->select();
                    if (!empty($history_tmp)) {
                        $v2_arr['invoice_historys'] = $history_tmp;
                        $v2_arr['invoice_historys_num'] = count($history_tmp);
                    } else {
                        $v2_arr['invoice_historys'] = [];
                        $v2_arr['invoice_historys_num'] = 0;
                    }
                    $tmp[] = $v2_arr;
                }
                $item->membership_detail_list = $tmp;
                if (!$has_child_data){
                    $has_child_data = !empty($tmp);
                }
                $item->has_child_data = !empty($tmp);
            }
        }
        $this->view->assign('hierarchy_list', $has_child_data?$hierarchy_list:[]);
        return $hierarchy_list;
    }

    /**
     * 初始化Membership
     * @param $ids
     * @return bool|\PDOStatement|string|\think\Collection
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    private function init_paidhierarchy($ids)
    {
        $hierarchy = new Hierarchy();
        $hierarchy_list = $hierarchy->where('hierarchy.memberid', $ids)
            ->with([
                'package' => function ($query) {
                    $query->withField('packagename');
                },
                'partner' => function ($query) {
                    $query->withField('login_name');
                }
            ])
            ->orderRaw("FIELD(hierarchy.contract_status, '', 'use', 'stop')")
            ->select();
        $has_child_data = false;
        if (!empty($hierarchy_list)) {
            $paid_method = new Method();
            foreach ($hierarchy_list as &$item) {
                $membership_detail_list = $hierarchy->alias('H')
                    ->fieldRaw("MBSD.ms_detail_id AS   ms_detail_id
					,  MBSD.total_week AS  week_per_year
					,  MBSD.ms_detail_year AS entitlement_year
					,  MBSD.special_amount
					,  MBSD.ms_detail_paid AS ms_detail_paid
					,  MBSD.ms_detail_used AS ms_detail_used
					,  MBSD.hierarchyid AS membership_id
					,  H.hierarchyid
					,  H.servicetype AS servicetype
					,  H.contract_no AS contract_no
					,  DATE_FORMAT(MBSD.ms_detail_paid_date,'%d/%m/%Y') AS 	paid_date
					,  DATE_FORMAT(MBSD.ms_detail_paid_date,'%H:%i') AS paid_time
					,  MBSD.paid_method AS paid_method
					,  MBSD.paid_amount AS paid_amount
					,  MBSD.paid_status AS paid_status
					,  MBSD.paid_remark AS paid_remark
					,  PK.packagename  AS package_name
					,  PK.packageid AS package_id

					,  PKP.packageprice_prices AS package_price

					,  PKP.packageprice_amount1 AS amount1
					,  PKP.packageprice_prices1 AS price1
					,  PKP.packageprice_amount2 AS amount2
					,  PKP.packageprice_prices2 AS price2
					,  PKP.packageprice_amount3 AS amount3
					,  PKP.packageprice_prices3 AS price3
					,  PKP.packageprice_amount4 AS amount4
					,  PKP.packageprice_prices4 AS price4
					,  PKP.packageprice_amount5 AS amount5
					,  PKP.packageprice_prices5 AS price5")
                    ->join('membership_detail MBSD', "MBSD.hierarchyid = H.hierarchyid", 'left')
                    ->join('package PK', "PK.packageid = MBSD.packageid", 'left')
                    ->join('packageprice PKP', "PKP.packageid = MBSD.packageid  AND PKP.packageprice_years = MBSD.ms_detail_year")
                    ->where('MBSD.hierarchyid', $item->hierarchyid)
                    ->whereRaw("MBSD.paid_status = 'Y'")
                    ->whereRaw("MBSD.ms_detail_paid = 'W' OR MBSD.ms_detail_paid = 'P'")
                    ->order('MBSD.ms_detail_year', 'asc')
                    ->select();
                $tmp = [];
                foreach ($membership_detail_list as $v2) {
                    $v2_arr = $v2->toArray();
                    $paid_method_name = $paid_method->where('paid_method_id', $v2_arr['paid_method'])
                        ->value('paid_method_name');
                    if (!empty($paid_method_name)) {
                        $v2_arr['paid_method_name'] = $paid_method_name;
                    } else {
                        $v2_arr['paid_method_name'] = '';
                    }
                    $tmp[] = $v2_arr;
                }
                $item->membership_detail_list = $tmp;
                if (!$has_child_data){
                    $has_child_data = !empty($tmp);
                }
                $item->has_child_data = !empty($tmp);
            }
        }
        $this->view->assign('paid_hierarchy_list',$has_child_data? $hierarchy_list:[]);
        return $hierarchy_list;
    }

    /**
     * @param $ids
     * @return void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    public function init_paidorder($ids)
    {
        $orders = new \app\admin\model\Orders();
        $orders_list = $orders->where('memberid', $ids)
            ->where('paid_completed', 'Y')
            ->whereRaw("status_new='N' OR status_new='E'")
            ->whereRaw("orders_renounce='O' OR orders_renounce='' OR ISNULL(orders_renounce)")
            ->whereRaw("booking_renounce='S' OR booking_renounce='' OR ISNULL(booking_renounce)")
            ->select();
        if (!empty($orders_list)) {
            $orders_addi = new Addi();
            $orders_bonus = new Bonus();
            $orders_extra = new Extra();
            $orders_van = new Van();
            $paid_method = new Method();
            foreach ($orders_list as &$v) {
                $sum_grandtotal = 0;
                $sum_paid_amount = 0;
                $num_total_service = 0;
                $result = $orders_addi->fieldRaw('COUNT(orders_addi_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(addi_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_bonus->fieldRaw('COUNT(orders_bonus_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(bonus_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_extra->fieldRaw('COUNT(orders_extra_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(extra_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_van->fieldRaw('COUNT(orders_van_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(van_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $v->num_total_service = $num_total_service;
                $v->sum_grandtotal = $sum_grandtotal;
                $v->sum_paid_amount = $sum_paid_amount;

                if (!empty($v->paid_method_str)) {
                    $tmp = $paid_method->whereIn('paid_method_id', $v->paid_method_str)->select();
                    if (!empty($tmp)) {
                        $v->paid_method_names = implode(',', array_column($tmp, 'paid_method_name'));
                    } else {
                        $v->paid_method_names = '-';
                    }
                } else {
                    $v->paid_method_names = '-';
                }
            }
        }
        $this->view->assign('paid_orders_list', $orders_list);
    }

    /**
     * 获取指定数据
     * @param $ms_detail_ids
     * @return bool|\PDOStatement|string|\think\Collection
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    private function get_membership_detail_list($ms_detail_ids)
    {
        if (is_string($ms_detail_ids)) {
            $ms_detail_ids = explode(',', $ms_detail_ids);
        }
        $ms_detail_ids = array_unique($ms_detail_ids);
        $hierarchy = new Hierarchy();
        return $hierarchy->alias('H')
            ->fieldRaw("MBSD.ms_detail_id AS   ms_detail_id
					,  MBSD.total_week AS  week_per_year
					,  MBSD.ms_detail_year AS entitlement_year
					,  MBSD.special_amount
					,  MBSD.ms_detail_paid AS ms_detail_paid
					,  MBSD.ms_detail_used AS ms_detail_used
					,  MBSD.hierarchyid AS membership_id
					,  H.hierarchyid
					,  H.servicetype AS servicetype
					,  H.contract_no AS contract_no
					,  DATE_FORMAT(MBSD.ms_detail_paid_date,'%d/%m/%Y') AS 	paid_date
					,  DATE_FORMAT(MBSD.ms_detail_paid_date,'%H:%i') AS paid_time
					,  MBSD.paid_method AS paid_method
					,  MBSD.paid_amount AS paid_amount
					,  MBSD.paid_status AS paid_status
					,  MBSD.paid_remark AS paid_remark
					,  PK.packagename  AS package_name
					,  PK.packageid AS package_id

					,  PKP.packageprice_prices AS package_price

					,  PKP.packageprice_amount1 AS amount1
					,  PKP.packageprice_prices1 AS price1
					,  PKP.packageprice_amount2 AS amount2
					,  PKP.packageprice_prices2 AS price2
					,  PKP.packageprice_amount3 AS amount3
					,  PKP.packageprice_prices3 AS price3
					,  PKP.packageprice_amount4 AS amount4
					,  PKP.packageprice_prices4 AS price4
					,  PKP.packageprice_amount5 AS amount5
					,  PKP.packageprice_prices5 AS price5")
            ->join('membership_detail MBSD', "MBSD.hierarchyid = H.hierarchyid", 'left')
            ->join('package PK', "PK.packageid = MBSD.packageid", 'left')
            ->join('packageprice PKP', "PKP.packageid = MBSD.packageid  AND PKP.packageprice_years = MBSD.ms_detail_year")
            ->whereIn('MBSD.ms_detail_id', $ms_detail_ids)
            ->whereRaw("MBSD.paid_status = 'N' OR MBSD.paid_status='' OR ISNULL(MBSD.paid_status)")
            ->whereRaw("MBSD.ms_detail_paid = 'W' OR MBSD.ms_detail_paid = 'N' OR MBSD.ms_detail_paid='P'")
            ->order('MBSD.ms_detail_year', 'asc')
            ->select();
    }


    /**
     * @param $orders_id
     * @return bool|\PDOStatement|string|Collection
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    private function get_unpaidorders($orders_id)
    {
        if (is_string($orders_id)) {
            $orders_id = explode(',', $orders_id);
        }
        $orders = new \app\admin\model\Orders();
        $orders_list = $orders->whereIn('orders_id', $orders_id)
            ->where('paid_completed', 'N')
            ->whereRaw("status_new='N' OR status_new='E'")
            ->select();
        if (!empty($orders_list)) {
            $orders_addi = new Addi();
            $orders_bonus = new Bonus();
            $orders_extra = new Extra();
            $orders_van = new Van();
            $paid_method = new Method();
            foreach ($orders_list as &$v) {
                $sum_grandtotal = 0;
                $sum_paid_amount = 0;
                $num_total_service = 0;
                $result = $orders_addi->fieldRaw('COUNT(orders_addi_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(addi_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_bonus->fieldRaw('COUNT(orders_bonus_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(bonus_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_extra->fieldRaw('COUNT(orders_extra_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(extra_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_van->fieldRaw('COUNT(orders_van_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(van_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $v->num_total_service = $num_total_service;
                $v->sum_grandtotal = $sum_grandtotal;
                $v->sum_paid_amount = $sum_paid_amount;

                if (!empty($v->paid_method_str)) {
                    $tmp = $paid_method->whereIn('paid_method_id', $v->paid_method_str)->select();
                    if (!empty($tmp)) {
                        $v->paid_method_names = implode(',', array_column($tmp, 'paid_method_name'));
                    } else {
                        $v->paid_method_names = '-';
                    }
                } else {
                    $v->paid_method_names = '-';
                }
            }
        }
        return $orders_list;
    }

    /**
     * 支付
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     * @throws Exception
     */
    public function payment()
    {
        $post_data = input('post.');
        $type = input('type');
        $user = $this->auth->getUser();
        $memberid = $user->member->memberid;
        $invoice_bank = new Bank();
        if ($type === 'mf') {
            if (empty($post_data['ms_detail_id'])) {
                $this->error(__('Param error'));
            }
            $membership_detail_list = $this->get_membership_detail_list($post_data['ms_detail_id']);
            if (empty($membership_detail_list)) {
                $this->error('No data need to pay');
            }
            $invoice_data = genInvoiceNo($memberid);
            $bank_invoice_id = $invoice_data[0];
            $bank_invoice_no = $invoice_data[1];

            $invoice_bank->insert([
                'bank_invoice_id' => $bank_invoice_id,
                'bank_invoice_no' => $bank_invoice_no,
                'bank_invoice_year' => date('Y'),
                'memberid' => $memberid,
                'created_by' => $memberid,
                'created_on' => date('Y-m-d H:i:s'),
                'invoice_type' => 'MF',
            ]);

            $total_price = 0;
            foreach ($membership_detail_list as $item) {
                $price = $item['special_amount'] > 0 ? $item['special_amount'] : $item['package_price'];
                $total_price += $price;
                Transaction::create([
                    'bank_invoice_id' => $bank_invoice_id,
                    'bank_invoice_no' => $bank_invoice_no,
                    'ms_detail_id' => $item['ms_detail_id'],
                    'paid_method' => 1,
                    'paid_amount' => $price,
                    'ms_detail_paid' => 'P',
                    'ms_detail_paid_date' => date('Y-m-d H:i:s'),
                    'paid_status' => 'Y',
                    'start_advance_year' => '',
                    'advance_to_year' => '',
                    'entitlement_year' => $item['entitlement_year'],
                    'total_advance_year' => 1,
                    'week_per_year' => $item['week_per_year'],
                    'member_id' => $memberid,
                    'membership_id' => $item['hierarchyid'],
                    'membership_type_name' => $item['package_name'],
                    'membership_type_id' => $item['package_id'],
                    'send_to_bank' => 'N',
                    'bank_responce' => 0,
                    'test_value' => 'A',
                ]);
            }
            $total_price = number_format($total_price, 2, '.', '');
            $this->view->assign('total_price', $total_price);
            $this->view->assign('type', $type);
            $this->view->assign('ms_detail_ids', implode(',', $post_data['ms_detail_id']));
            $this->view->assign('detail', 'Management Fee');
            $this->view->assign('bank_invoice_no', $bank_invoice_no);
            $this->view->assign('title', __('Kasikorn Bank PaymentGateway System'));
            $this->view->assign('payment_config', $this->get_current_payment());
            return $this->view->fetch();
        } else if ($type === 'of') {
            if (empty($post_data['orders_id'])) {
                $this->error(__('Param error'));
            }
            $invoice_data = genInvoiceNo($memberid);
            $bank_invoice_id = $invoice_data[0];
            $bank_invoice_no = $invoice_data[1];

            $invoice_bank->insert([
                'bank_invoice_id' => $bank_invoice_id,
                'bank_invoice_no' => $bank_invoice_no,
                'bank_invoice_year' => date('Y'),
                'memberid' => $memberid,
                'created_by' => $memberid,
                'created_on' => date('Y-m-d H:i:s'),
                'invoice_type' => 'OF',
            ]);
            $invoice_bank_order = new Order();
            $total_price = 0;
            $orders_list = $this->get_unpaidorders($post_data['orders_id']);
            if (empty($orders_list)) {
                $this->error('No data need to pay');
            }
            foreach ($orders_list as $item) {
                $total_price += $item['sum_grandtotal'];
                $invoice_bank_order->insert([
                    'bank_invoice_id' => $bank_invoice_id,
                    'orders_id' => $item['orders_id'],
                    'orders_price' => $item['sum_grandtotal']
                ]);
            }
            $total_price = number_format($total_price, 2, '.', '');
            $this->view->assign('total_price', $total_price);
            $this->view->assign('type', $type);
            $this->view->assign('orders_ids', implode(',', $post_data['orders_id']));
            $this->view->assign('detail', 'Order Fee');
            $this->view->assign('bank_invoice_no', $bank_invoice_no);
            $this->view->assign('title', __('Kasikorn Bank PaymentGateway System'));
            $this->view->assign('payment_config', $this->get_current_payment());
            return $this->view->fetch();
        } else {
            $this->error(__('Param error'));
        }
    }

    /**
     * 获取当前支付配置
     * @return mixed
     */
    private function get_current_payment()
    {
        return get_current_payment();
    }

    /**
     * @return \think\response\Json
     */
    public function api_qr_order()
    {
        $amount = input('amount');
        $source_type = input('source_type');
        $ref_order = input('ref_order');
        $description = input('description');
        $payment_config = $this->get_current_payment();
        $mid = $source_type == 'qr' ? ($payment_config['sand_merchant']['qr'] ?? null) : ($payment_config['sand_merchant']['wechat'] ?? null);
        $payment_api_url = $payment_config['sand_payment_api_sdomain'];
        $kpayment_url = $payment_config['sand_payment_api_domain'];
        $payment_api_pkey = $payment_config['sand_payment_api_pkey'];
        $currency = $payment_config['currency'];
        $charge_api = '/qr/v2/order';
        $HTTPHEADER = [
            'Content-Type: application/json; charset=utf-8',
            'x-api-key: ' . $payment_config['sand_payment_api_skey']
        ];

        $data_request = json_encode([
            'amount' => $amount,
            'currency' => $currency,
            'description' => $description,
            'source_type' => $source_type,
            'reference_order' => $ref_order,
            'additional_data' => [
                'mid' => $mid
            ]
        ], JSON_PRETTY_PRINT);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $payment_api_url . $charge_api);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $HTTPHEADER);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_request);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        curl_close($ch);
        $data_json = json_decode($response, true);
        if (!empty($data_json['id'])) {
            $status = 1;
        } else {
            $status = 0;
        }
        return json([
            'status' => $status,
            'data' => $data_json
        ]);
    }

    /**
     * 保存支付信息
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    public function save_payment()
    {
        $post_data = input('post.');
        $type = input('type');
        $user = $this->auth->getUser();
        $memberid = $user->member->memberid;
        if ($type === 'mf') {
            if (empty($post_data['ms_detail_ids']) || empty($post_data['bank_invoice_no'])) {
                $this->error(__('Param error'));
            }
            $membership_detail_list = $this->get_membership_detail_list($post_data['ms_detail_ids']);
            if (empty($membership_detail_list)) {
                $this->error('No data need to pay');
            }
            $membership_detail = new Detail();
            foreach ($membership_detail_list as $item) {
                $membership_detail->where('memberid', $memberid)
                    ->where('hierarchyid', $item['hierarchyid'])
                    ->where('packageid', $item['package_id'])
                    ->where('ms_detail_year', $item['entitlement_year'])
                    ->update([
                        'paid_amount' => $item['package_price'],
                        'bank_invoice_no' => $post_data['bank_invoice_no']
                    ]);
                PaymentRecorde($item['ms_detail_id'], $item['package_price'], 1, "MF", "N", $post_data['bank_invoice_no']);
            }
            return $this->send2bank($post_data);
        } else if ($type === 'of') {
            if (empty($post_data['orders_ids']) || empty($post_data['bank_invoice_no'])) {
                $this->error(__('Param error'));
            }
            $orders_list = $this->get_unpaidorders($post_data['orders_ids']);
            if (empty($orders_list)) {
                $this->error('No data need to pay');
            }
            $orders = new Orders();
            $orders_addi = new Addi();
            $orders_bonus = new Bonus();
            $orders_extra = new Extra();
            $orders_van = new Van();
            foreach ($orders_list as $item) {
                $orders_id = $item['orders_id'];
                $orders->where('orders_id', $orders_id)->update([
                    'bank_invoice_no' => $post_data['bank_invoice_no']
                ]);
                $orders_addi->where('orders_id', $orders_id)->update([
                    'paid_method_id' => 1
                ]);
                $orders_bonus->where('orders_id', $orders_id)->update([
                    'paid_method_id' => 1
                ]);
                $orders_extra->where('orders_id', $orders_id)->update([
                    'paid_method_id' => 1
                ]);
                $orders_van->where('orders_id', $orders_id)->update([
                    'paid_method_id' => 1
                ]);
            }
            return $this->send2bank($post_data);
        } else {
            $this->error(__('Param error'));
        }
    }

    /**
     * 发送支付
     * @param $data
     * @return string|void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws Exception
     * @throws ModelNotFoundException
     */
    private function send2bank($post_data)
    {
        $user = $this->auth->getUser();
        $memberid = $user->member->memberid;
        $invoice_bank_transaction = new Transaction();
        $invoice_bank_transaction->where('bank_invoice_no', $post_data['bank_invoice_no'])->update([
            'send_to_bank' => 'Y'
        ]);
        $payment_config = $this->get_current_payment();
        $kpayment_url = $payment_config['payment_api_sdomain'];
        $currency = $payment_config['currency'];
        $merchant_id = $payment_config['merchant'][0];
        $payment_method = $post_data['payment_method'];
        $HTTPHEADER = [
            'Content-Type: application/json; charset=utf-8',
            'x-api-key: ' . $payment_config['payment_api_skey']
        ];
        $send2bank = new Send2bank();
        if ($payment_method == 'credit') {
            $charge_api = '/card/v2/charge';
            $amount = $post_data['total_price'];
            $data = json_encode([
                'amount' => $amount,
                'currency' => $currency,
                'description' => $post_data['detail'],
                'source_type' => 'card',
                'mode' => 'token',
                'token' => $post_data['token'],
                'reference_order' => $post_data['bank_invoice_no'],
                'additional_data' => [
                    'mid' => empty($post_data['mid']) ? $merchant_id : $post_data['mid']
                ]
            ], JSON_PRETTY_PRINT);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $kpayment_url . $charge_api);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $HTTPHEADER);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            $response = curl_exec($ch);
            curl_close($ch);
            $data_json = json_decode($response, true);
            $send_id = $send2bank->insert([
                'merchant_id' => $merchant_id,
                'payment_method' => $payment_method,
                'charge_id' => !empty($data_json['id']) ? $data_json['id'] : '',
                'redirect_url' => !empty($data_json['redirect_url']) ? $data_json['redirect_url'] : '',
                'send_date' => date('dmY'),
                'send_invoice' => $post_data['bank_invoice_no'],
                'send_amount' => $amount,
                'currency' => $currency,
                'created_by' => $memberid,
                'created_on' => date('Y-m-d H:i:s')
            ], false, true);
            if ($data_json['status'] == 'success' && $data_json['transaction_state'] == 'Pre-Authorized') {
                $this->redirect($data_json['redirect_url']);
            } else {
                $resp_code = '';
                $payment_status = '';
                if (isset($data_json['status'])) {
                    $new_json = json_encode($data_json, JSON_PRETTY_PRINT);
                    $HTTP_REFERER = ($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : "xxx";
                    $payment_status = $data_json['status'];
                    $invoice = $data_json['reference_order'];
                    $resp_code = $payment_status == 'success' ? '00' : '66';

                    $invoice_response = new Response();
                    $invoice_response->insert([
                        'resp_code' => $resp_code,
                        'payment_status' => $payment_status,
                        'reference' => $data_json['id'],
                        'authorize' => $data_json['approval_code'],
                        'uaid' => $data_json['transaction_state'],
                        'invoice' => $invoice,
                        'timestamp' => $data_json['created'],
                        'amount' => $data_json['amount'],
                        'checksum' => '',
                        'cardtype' => $data_json['source']['brand'],
                        'checksumcard2' => $data_json['source']['card_masking'],
                        'PMGWRESP' => $response,
                        'http_referer' => $HTTP_REFERER,
                        'all_post_return' => '',
                        'all_get_return' => '',
                        'remark' => 'Responce Transaction',
                        'response_datetime' => date('Y-m-d H:i:s'),
                    ]);

                    $send2bank->where('send_invoice', $invoice)->update([
                        'responce_last' => date('Y-m-d H:i:s')
                    ]);
                    $send2bank->where('send_invoice', $invoice)->setInc('responce_time');
                    $invoice_bank_transaction = new Transaction();
                    $invoice_bank_transaction->where('bank_invoice_no', $invoice)->update([
                        'responce_time' => date('Y-m-d H:i:s'),
                        'responce_code' => $resp_code
                    ]);
                    $invoice_bank_transaction->where('bank_invoice_no', $invoice)->setInc('bank_responce');
                    if ($resp_code == "00") {
                        $membership_detail = new Detail();
                        $query = $invoice_bank_transaction->where('bank_invoice_no', $invoice)->select();
                        if (!empty($query)) {
                            foreach ($query as $row) {
                                $membership_detail->where('ms_detail_id', $row['ms_detail_id'])->update([
                                    'paid_amount' => $row['paid_amount'],
                                    'paid_status' => 'Y',
                                    'ms_detail_paid' => 'P',
                                    'ms_detail_paid_date' => date('Y-m-d H:i:s'),
                                    'paid_method' => 1,
                                    'bank_invoice_no' => $row['bank_invoice_no']
                                ]);
                            }
                        } else {
                            $query = $membership_detail->where('bank_invoice_no', $invoice)->find();
                            if (!empty($query)) {
                                $membership_detail->where('bank_invoice_no', $invoice)->update([
                                    'paid_status' => 'Y',
                                    'ms_detail_paid' => 'P',
                                    'ms_detail_paid_date' => date('Y-m-d H:i:s'),
                                    'paid_method' => 1
                                ]);
                            }
                        }
                        $payment_record = new Record();
                        $payment_record->where('invoice_bank', $invoice)->update([
                            'paid_status' => 'Y'
                        ]);

                        $sql_orders = "SELECT bank_invoice_no, orders_id FROM orders WHERE bank_invoice_no = '{$invoice}' ";
                        $query_orders = Db::query($sql_orders);
                        if (!empty($query_orders)) {
                            $row_select = $query_orders[0];
                            $orders_id = $row_select['orders_id'];
                            $sql = "
								UPDATE orders SET status_paid = 'P'
									, status_new = 'E'
									, paid_completed = 'Y'
									, paid_date = NOW()
									, paid_method_str = '1'
									, paid_method_id = '1'
								WHERE bank_invoice_no = '{$invoice}' 
							";
                            Db::execute($sql);

                            $sql = "UPDATE orders_addi SET status_paid='P' , addi_paid='Y', addi_paid_amount=grand_total WHERE orders_id = '{$orders_id}' ";
                            Db::execute($sql);

                            $sql = "UPDATE orders_bonus SET status_paid='P' , bonus_paid='Y', bonus_paid_amount=grand_total WHERE orders_id = '{$orders_id}' ";
                            Db::execute($sql);

                            $sql = "UPDATE orders_extra SET status_paid='P' , extra_paid='Y', extra_paid_amount=grand_total WHERE orders_id = '{$orders_id}' ";
                            Db::execute($sql);

                            $sql = "UPDATE orders_van SET status_paid='P' , van_paid='Y', van_paid_amount=grand_total WHERE orders_id = '{$orders_id}' ";
                            Db::execute($sql);
                        }
                    }
                }
                $this->view->assign('total_price', $post_data['total_price']);
                $this->view->assign('type', $post_data['type']);
                $this->view->assign('detail', $post_data['detail']);
                $this->view->assign('payment_status', $payment_status);
                $this->view->assign('bank_invoice_no', $post_data['bank_invoice_no']);
                $this->view->assign('title', __('Kasikorn Bank PaymentGateway System'));
                return $this->view->fetch();
            }
        } else if (in_array($payment_method, ['union_pay', 'alipay'])) {
            $charge_api = '/card/v2/charge';
            $amount = $post_data['total_price'];

            $data_json = null;
            if ($payment_method == 'union_pay') {
                $mid = $payment_config['merchant'][0];
                $data = json_encode([
                    'amount' => $amount,
                    'currency' => $currency,
                    'description' => $post_data['detail'],
                    'source_type' => 'unionpay',
                    'reference_order' => $post_data['bank_invoice_no'],
                    'additional_data' => [
                        'mid' => $mid
                    ]
                ], JSON_PRETTY_PRINT);
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $kpayment_url . $charge_api);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $HTTPHEADER);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                $response = curl_exec($ch);
                curl_close($ch);

                $data_json = json_decode($response, true);

            } elseif ($payment_method == 'alipay') {
                $kpayment_url = $payment_config['sand_payment_api_sdomain'];
                $mid = $payment_config['sand_merchant']['alipay'] ?? null;

                $HTTPHEADER = [
                    'Content-Type: application/json; charset=utf-8',
                    'x-api-key: ' . $payment_config['sand_payment_api_skey']
                ];
                $data = json_encode([
                    'amount' => $amount,
                    'currency' => $currency,
                    'description' => $post_data['detail'],
                    'source_type' => 'alipay',
                    'reference_order' => $post_data['bank_invoice_no']
                ], JSON_PRETTY_PRINT);
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $kpayment_url . $charge_api);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $HTTPHEADER);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                $response = curl_exec($ch);
                curl_close($ch);

                $data_json = json_decode($response, true);
            }

            if ($data_json && !empty($data_json['status']) && $data_json['status'] == 'success' && $data_json['transaction_state'] == 'Initialize') {
                $send_id = $send2bank->insert([
                    'merchant_id' => $mid,
                    'payment_method' => $payment_method,
                    'charge_id' => !empty($data_json['id']) ? $data_json['id'] : '',
                    'redirect_url' => !empty($data_json['redirect_url']) ? $data_json['redirect_url'] : '',
                    'send_date' => date('dmY'),
                    'send_invoice' => $post_data['bank_invoice_no'],
                    'send_amount' => $amount,
                    'currency' => $currency,
                    'created_by' => $memberid,
                    'created_on' => date('Y-m-d H:i:s')
                ], false, true);
                $this->redirect($data_json['redirect_url']);
            }
            $this->error(__('Payment error'));
        } else if (in_array($payment_method, ['qr', 'wechat'])) {
            $kpayment_url = $payment_config['sand_payment_api_domain'];
            $payment_api_pkey = $payment_config['sand_payment_api_pkey'];

            $mid = $payment_method == 'qr' ? ($payment_config['sand_merchant']['qr'] ?? '') : ($payment_config['sand_merchant']['wechat'] ?? '');

            $arr_method = [
                'qr' => 'Thai QR code',
                'wechat' => 'WeChat Pay'
            ];
            $payment_amount = number_format($post_data['total_price'], 2, '.', '');

            if (!empty($post_data['order_id'])) {
                $send_id = $send2bank->insert([
                    'merchant_id' => $mid,
                    'payment_method' => $payment_method,
                    'charge_id' => !empty($post_data['order_id']) ? $post_data['order_id'] : '',
                    'redirect_url' => '',
                    'send_date' => date('dmY'),
                    'send_invoice' => $post_data['bank_invoice_no'],
                    'send_amount' => $payment_amount,
                    'currency' => $currency,
                    'created_by' => $memberid,
                    'created_on' => date('Y-m-d H:i:s')
                ], false, true);
            }
            $this->view->assign('kpayment_url', $kpayment_url);
            $this->view->assign('payment_api_pkey', $payment_api_pkey);
            $this->view->assign('arr_method', $arr_method);
            $this->view->assign('payment_method', $payment_method);
            $this->view->assign('order_id', $post_data['order_id']);
            $this->view->assign('total_price', $post_data['total_price']);
            $this->view->assign('type', $post_data['type']);
            $this->view->assign('detail', $post_data['detail']);
            $this->view->assign('payment_status', '');
            $this->view->assign('bank_invoice_no', $post_data['bank_invoice_no']);
            $current_payment = \config('current_payment');
            if ($current_payment === 'payment_thb') {
                $current_payment_url = url('/thb/payment/' . $payment_method . '/callback');
            } else {
                $current_payment_url = url('/payment/' . $payment_method . '/callback');
            }
            $this->view->assign('current_payment_url', $current_payment_url);
            $this->view->assign('title', __('Kasikorn Bank PaymentGateway System'));
            return $this->view->fetch();
        } else {

        }
        $this->error(__('Payment error'));
    }
}
