<?php

namespace app\payment\controller;

use app\common\controller\Frontend;
use think\Db;

/**
 * 定时处理订单支付数据
 */
class PayCallback extends Frontend
{
    protected $noNeedLogin = '*';
    protected $noNeedRight = '*';
    protected $layout = '';

    public function task()
    {
        $day = 3;
        $num = 10;
        if (!empty($_REQUEST['num'])) {
            $num = intval($_REQUEST['num']);
        }

        if (!empty($_REQUEST['day'])) {
            $day = intval($_REQUEST['day']);
        }

        if ($num < 1) {
            exit('参数错误');
        }
        $sql = <<<SQL
        SELECT * FROM `send2bank` where `responce_time` = ? AND `charge_id` != ? AND `created_on` < ? order by `send_id` desc LIMIT ? 
SQL;

        $end_day = date('Y-m-d H:i:s', time() - $day * 86400);

        $items = Db::query($sql, [0, '', $end_day, $num]);
        if (!empty($items)) {
            foreach ($items as $item) {
                echo 'charge_id ' . $item['charge_id'] . '<br>';
                $inquiry_trans = qr_inquiry_transaction($item['charge_id'], 0, false);
                if (empty($inquiry_trans['order_id'])) {
                    echo '调用 api_inquiry_transaction<br>';
                    api_inquiry_transaction($item['charge_id'], 0, 1);
                } else {
                    echo '调用 qr_inquiry_transaction<br>';
                }
            }
        } else {
            exit('no data');
        }
    }
}